/*
 * Decompiled with CFR 0.152.
 */
package dev.militronix.zoom;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="zoommod")
public class ZoomMod {
    public static final String MODID = "zoommod";
    private static final float DEFAULT_ZOOM_FACTOR = 0.5f;
    private static final float SMOOTH_SPEED = 0.5f;
    private static float currentZoom = 1.0f;
    private static float targetZoom = 1.0f;
    private static final KeyMapping ZOOM_KEY = new KeyMapping("key.zoommod.zoom", 67, "key.categories.misc");

    @Mod.EventBusSubscriber(modid="zoommod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            ItemStack mainHandItem = Minecraft.m_91087_().f_91074_.m_21205_();
            targetZoom = !mainHandItem.m_41619_() ? (ForgeRegistries.ITEMS.getKey((Object)mainHandItem.m_41720_()) != null && "pointblank".equals(ForgeRegistries.ITEMS.getKey((Object)mainHandItem.m_41720_()).m_135827_()) ? 1.0f : (ZOOM_KEY.m_90857_() ? 0.5f : 1.0f)) : (ZOOM_KEY.m_90857_() ? 0.5f : 1.0f);
            currentZoom += (targetZoom - currentZoom) * 0.5f;
        }

        @SubscribeEvent
        public static void onComputeFovModifier(ComputeFovModifierEvent event) {
            float originalFov = event.getNewFovModifier();
            event.setNewFovModifier(originalFov * currentZoom);
        }

        @SubscribeEvent
        public static void onRenderHand(RenderHandEvent event) {
            float HAND_OFFSET_FACTOR = 0.5f;
            float zOffset = (1.0f - currentZoom) * 0.5f;
            event.getPoseStack().m_252880_(0.0f, 0.0f, zOffset);
        }
    }

    @Mod.EventBusSubscriber(modid="zoommod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class KeyRegistration {
        @SubscribeEvent
        public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(ZOOM_KEY);
        }
    }
}

