/*
 * Decompiled with CFR 0.152.
 */
package fr.flaton.walkietalkie.network.packet.c2s;

import dev.architectury.networking.NetworkManager;
import fr.flaton.walkietalkie.Util;
import fr.flaton.walkietalkie.config.ModConfig;
import fr.flaton.walkietalkie.item.WalkieTalkieItem;
import fr.flaton.walkietalkie.network.ModMessages;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class UpdateWalkieTalkieC2SPacket {
    public static void receive(FriendlyByteBuf packetByteBuf, NetworkManager.PacketContext packetContext) {
        ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
        ItemStack stack = Util.getWalkieTalkieInHand((Player)player);
        if (!(stack.m_41720_() instanceof WalkieTalkieItem) && !stack.m_41782_()) {
            return;
        }
        int index = packetByteBuf.readInt();
        boolean status = packetByteBuf.readBoolean();
        boolean activate = stack.m_41783_().m_128471_("walkietalkie.activate");
        boolean mute = stack.m_41783_().m_128471_("walkietalkie.mute");
        int canal = stack.m_41783_().m_128451_("walkietalkie.canal");
        switch (index) {
            case 0: {
                activate = !activate;
                break;
            }
            case 1: {
                if (status) {
                    canal = Util.loop(canal + 1, 1, ModConfig.maxCanal);
                    break;
                }
                canal = Util.loop(canal - 1, 1, ModConfig.maxCanal);
                break;
            }
            case 2: {
                mute = !mute;
            }
        }
        stack.m_41783_().m_128379_("walkietalkie.activate", activate);
        stack.m_41783_().m_128379_("walkietalkie.mute", mute);
        stack.m_41783_().m_128405_("walkietalkie.canal", canal);
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130055_(stack);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)ModMessages.UPDATE_WALKIETALKIE_S2C, (FriendlyByteBuf)packet);
    }
}

