/*
 * Decompiled with CFR 0.152.
 */
package fr.flaton.walkietalkie.client.gui.screen;

import dev.architectury.networking.NetworkManager;
import fr.flaton.walkietalkie.client.gui.widget.ToggleImageButton;
import fr.flaton.walkietalkie.network.ModMessages;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class WalkieTalkieScreen
extends Screen {
    private static WalkieTalkieScreen instance;
    private final int xSize = 195;
    private final int ySize = 76;
    private int guiLeft;
    private int guiTop;
    private final ItemStack stack;
    private ToggleImageButton mute;
    private ToggleImageButton activate;
    private Component canal;
    private static final ResourceLocation BG_TEXTURE;
    private static final ResourceLocation MUTE_TEXTURE;
    private static final ResourceLocation ACTIVATE_TEXTURE;

    public WalkieTalkieScreen(ItemStack stack) {
        super((Component)Component.m_237115_((String)"gui.walkietalkie.title"));
        instance = this;
        this.stack = stack;
        Minecraft.m_91087_().m_91152_((Screen)this);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - 195) / 2;
        this.guiTop = (this.f_96544_ - 76) / 2;
        this.mute = new ToggleImageButton(this.guiLeft + 6, this.guiTop + 76 - 6 - 20, MUTE_TEXTURE, button -> this.sendUpdateWalkieTalkie(2, false), this.stack.m_41783_().m_128471_("walkietalkie.mute"));
        this.m_142416_((GuiEventListener)this.mute);
        this.activate = new ToggleImageButton(this.guiLeft + 28, this.guiTop + 76 - 26, ACTIVATE_TEXTURE, button -> this.sendUpdateWalkieTalkie(0, false), this.stack.m_41783_().m_128471_("walkietalkie.activate"));
        this.m_142416_((GuiEventListener)this.activate);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.sendUpdateWalkieTalkie(1, true)).m_252987_(this.f_96543_ / 2 - 10 + 40, this.guiTop + 20, 20, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.sendUpdateWalkieTalkie(1, false)).m_252987_(this.f_96543_ / 2 - 10 - 40, this.guiTop + 20, 20, 20).m_253136_());
        this.canal = Component.m_237113_((String)String.valueOf(this.stack.m_41783_().m_128451_("walkietalkie.canal")));
    }

    private void sendUpdateWalkieTalkie(int index, boolean status) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(index);
        buf.writeBoolean(status);
        NetworkManager.sendToServer((ResourceLocation)ModMessages.UPDATE_WALKIETALKIE_C2S, (FriendlyByteBuf)buf);
    }

    public void m_280273_(GuiGraphics context) {
        super.m_280273_(context);
        context.m_280218_(BG_TEXTURE, this.guiLeft, this.guiTop, 0, 0, 195, 76);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.drawCenteredText(context, this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.guiTop + 7, 0x404040);
        this.drawCenteredText(context, this.f_96547_, this.canal, this.f_96543_ / 2, this.guiTop + 26, 0x404040);
    }

    protected void drawCenteredText(GuiGraphics context, Font textRenderer, Component text, int centerX, int y, int color) {
        context.m_280614_(textRenderer, text, centerX - textRenderer.m_92852_((FormattedText)text) / 2, y, color, false);
    }

    public void updateButtons(ItemStack stack) {
        this.mute.setState(stack.m_41783_().m_128471_("walkietalkie.mute"));
        this.activate.setState(stack.m_41783_().m_128471_("walkietalkie.activate"));
        this.canal = Component.m_237113_((String)String.valueOf(stack.m_41783_().m_128451_("walkietalkie.canal")));
    }

    public static WalkieTalkieScreen getInstance() {
        return instance;
    }

    static {
        BG_TEXTURE = new ResourceLocation("walkietalkie", "textures/gui/gui_walkietalkie.png");
        MUTE_TEXTURE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
        ACTIVATE_TEXTURE = new ResourceLocation("walkietalkie", "textures/icons/activate.png");
    }
}

