/*
 * Decompiled with CFR 0.152.
 */
package fr.flaton.walkietalkie.block.entity;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import fr.flaton.walkietalkie.Util;
import fr.flaton.walkietalkie.block.entity.ModBlockEntities;
import fr.flaton.walkietalkie.config.ModConfig;
import fr.flaton.walkietalkie.screen.SpeakerScreenHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SpeakerBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final List<SpeakerBlockEntity> speakerBlockEntities = new ArrayList<SpeakerBlockEntity>();
    public static final String NBT_KEY_ACTIVATE = "speaker.activate";
    public static final String NBT_KEY_CANAL = "speaker.canal";
    protected final ContainerData propertyDelegate;
    boolean activated;
    int canal = 1;
    private final UUID channelId;
    private LocationalAudioChannel channel = null;

    public SpeakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SPEAKER.get(), pos, state);
        speakerBlockEntities.add(this);
        this.channelId = UUID.randomUUID();
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> {
                        if (SpeakerBlockEntity.this.activated) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 1 -> SpeakerBlockEntity.this.canal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        SpeakerBlockEntity.this.activated = value == 1;
                        break;
                    }
                    case 1: {
                        SpeakerBlockEntity.this.canal = value;
                        break;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new SpeakerScreenHandler(syncId, this.propertyDelegate, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_()));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.walkietalkie.speaker.title");
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.activated = nbt.m_128471_(NBT_KEY_ACTIVATE);
        this.canal = nbt.m_128451_(NBT_KEY_CANAL);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_(NBT_KEY_ACTIVATE, this.activated);
        nbt.m_128405_(NBT_KEY_CANAL, this.canal);
    }

    public boolean m_7531_(int type, int data) {
        return super.m_7531_(type, data);
    }

    public static List<SpeakerBlockEntity> getSpeakersActivatedInRange(int canal, Level world, Vec3 pos, int range) {
        speakerBlockEntities.removeIf(BlockEntity::m_58901_);
        ArrayList<SpeakerBlockEntity> list = new ArrayList<SpeakerBlockEntity>();
        for (SpeakerBlockEntity speaker : speakerBlockEntities) {
            if (!speaker.m_58898_() || !ModConfig.crossDimensionsEnabled && !world.m_46472_().m_211136_().equals((Object)speaker.m_58904_().m_46472_().m_211136_()) || !speaker.canBroadcastToSpeaker(world, pos, speaker, range) || !speaker.activated || speaker.canal != canal) continue;
            list.add(speaker);
        }
        return list;
    }

    public void playSound(VoicechatServerApi api, MicrophonePacketEvent event) {
        Position pos = api.createPosition((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_());
        if (this.channel == null) {
            this.channel = api.createLocationalAudioChannel(this.channelId, api.fromServerLevel((Object)this.f_58857_), pos);
            if (this.channel == null) {
                return;
            }
            this.channel.setCategory("speakers");
            this.channel.setDistance((float)ModConfig.speakerDistance + 1.0f);
            if (!ModConfig.voiceDuplication) {
                this.channel.setFilter(serverPlayer -> !serverPlayer.getEntity().equals(event.getSenderConnection().getPlayer().getEntity()));
            }
        }
        this.channel.send(((MicrophonePacket)event.getPacket()).getOpusEncodedData());
    }

    private boolean canBroadcastToSpeaker(Level senderWorld, Vec3 senderPos, SpeakerBlockEntity speaker, int range) {
        Level receiverWorld = speaker.m_58904_();
        if (receiverWorld == null) {
            return false;
        }
        return Util.canBroadcastToReceiver(senderWorld, receiverWorld, senderPos, speaker.f_58858_.m_252807_(), range);
    }
}

