/*
 * Decompiled with CFR 0.152.
 */
package fr.flaton.walkietalkie;

import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.VolumeCategory;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import de.maxhenkel.voicechat.api.packets.StaticSoundPacket;
import fr.flaton.walkietalkie.Util;
import fr.flaton.walkietalkie.block.entity.SpeakerBlockEntity;
import fr.flaton.walkietalkie.config.ModConfig;
import fr.flaton.walkietalkie.item.WalkieTalkieItem;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@ForgeVoicechatPlugin
public class WalkieTalkieVoiceChatPlugin
implements VoicechatPlugin {
    public static final String SPEAKER_CATEGORY = "speakers";
    @Nullable
    public static VoicechatServerApi api;

    public String getPluginId() {
        return "walkietalkie";
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicPacket);
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStarted);
    }

    private void onServerStarted(VoicechatServerStartedEvent event) {
        api = event.getVoicechat();
        VolumeCategory speakers = api.volumeCategoryBuilder().setId(SPEAKER_CATEGORY).setName("Speakers").setDescription("The volume of all speakers").setIcon(this.getIcon("assets/walkietalkie/textures/block/speaker.png")).build();
        api.registerVolumeCategory(speakers);
    }

    @Nullable
    private int[][] getIcon(String path) {
        try {
            Enumeration<URL> resources = WalkieTalkieVoiceChatPlugin.class.getClassLoader().getResources(path);
            while (resources.hasMoreElements()) {
                BufferedImage bufferedImage = ImageIO.read(resources.nextElement().openStream());
                if (bufferedImage.getWidth() != 16 || bufferedImage.getHeight() != 16) continue;
                int[][] image = new int[16][16];
                for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                    for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                        image[x][y] = bufferedImage.getRGB(x, y);
                    }
                }
                return image;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void onMicPacket(MicrophonePacketEvent event) {
        VoicechatConnection senderConnection = event.getSenderConnection();
        if (senderConnection == null) {
            return;
        }
        Object object = senderConnection.getPlayer().getPlayer();
        if (!(object instanceof Player)) {
            return;
        }
        Player senderPlayer = (Player)object;
        ItemStack senderItemStack = Util.getWalkieTalkieInHand(senderPlayer);
        if (senderItemStack == null) {
            return;
        }
        if (!this.isWalkieTalkieActivate(senderItemStack)) {
            return;
        }
        if (this.isWalkieTalkieMute(senderItemStack)) {
            return;
        }
        int senderCanal = this.getCanal(senderItemStack);
        SpeakerBlockEntity.getSpeakersActivatedInRange(senderCanal, senderPlayer.m_9236_(), senderPlayer.m_20182_(), this.getRange(senderItemStack)).forEach(speakerBlockEntity -> speakerBlockEntity.playSound(api, event));
        for (Player receiverPlayer : Objects.requireNonNull(senderPlayer.m_20194_()).m_6846_().m_11314_()) {
            VoicechatConnection connection;
            ItemStack receiverStack;
            if (receiverPlayer.m_20148_().equals(senderPlayer.m_20148_()) || !ModConfig.crossDimensionsEnabled && !receiverPlayer.m_9236_().m_6042_().equals((Object)senderPlayer.m_9236_().m_6042_()) || (receiverStack = Util.getWalkieTalkieActivated(receiverPlayer)) == null) continue;
            int receiverRange = this.getRange(receiverStack);
            int receiverCanal = this.getCanal(receiverStack);
            if (!this.canBroadcastToReceiver(senderPlayer, receiverPlayer, receiverRange) || receiverCanal != senderCanal || (connection = api.getConnectionOf(receiverPlayer.m_20148_())) == null) continue;
            api.sendStaticSoundPacketTo(connection, (StaticSoundPacket)((MicrophonePacket)event.getPacket()).staticSoundPacketBuilder().build());
        }
    }

    private int getCanal(ItemStack stack) {
        return Objects.requireNonNull(stack.m_41783_()).m_128451_("walkietalkie.canal");
    }

    private int getRange(ItemStack stack) {
        WalkieTalkieItem item = (WalkieTalkieItem)Objects.requireNonNull(stack.m_41720_());
        return item.getRange();
    }

    private boolean isWalkieTalkieActivate(ItemStack stack) {
        return Objects.requireNonNull(stack.m_41783_()).m_128471_("walkietalkie.activate");
    }

    private boolean isWalkieTalkieMute(ItemStack stack) {
        return Objects.requireNonNull(stack.m_41783_()).m_128471_("walkietalkie.mute");
    }

    private boolean canBroadcastToReceiver(Player senderPlayer, Player receiverPlayer, int receiverRange) {
        Level senderWorld = senderPlayer.m_9236_();
        Level receiverWorld = receiverPlayer.m_9236_();
        return Util.canBroadcastToReceiver(senderWorld, receiverWorld, senderPlayer.m_20182_(), receiverPlayer.m_20182_(), receiverRange);
    }
}

