/*
 * Decompiled with CFR 0.152.
 */
package fr.flaton.walkietalkie;

import fr.flaton.walkietalkie.config.ModConfig;
import fr.flaton.walkietalkie.item.WalkieTalkieItem;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static ItemStack getWalkieTalkieInHand(Player player) {
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        if (mainHand.m_41720_() instanceof WalkieTalkieItem) {
            return mainHand;
        }
        if (offHand.m_41720_() instanceof WalkieTalkieItem) {
            return offHand;
        }
        return null;
    }

    public static boolean canBroadcastToReceiver(Level senderWorld, Level receiverWorld, Vec3 senderPos, Vec3 receiverPos, int range) {
        double senderCoordinateScale = senderWorld.m_6042_().f_63859_();
        double receiverCoordinateScale = receiverWorld.m_6042_().f_63859_();
        double appliedRange = ModConfig.applyDimensionScale ? (double)range / Math.max(senderCoordinateScale, receiverCoordinateScale) : (double)range;
        return senderPos.m_82509_((Position)receiverPos, appliedRange);
    }

    public static ArrayList<ItemStack> getWalkieTalkies(Player player) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        Inventory playerInventory = player.m_150109_();
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            inventory.add((ItemStack)playerInventory.f_35974_.get(i));
        }
        inventory.addAll((Collection<ItemStack>)playerInventory.f_35976_);
        for (ItemStack stack : inventory) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof WalkieTalkieItem) || !stack.m_41782_()) continue;
            itemStacks.add(stack);
        }
        return itemStacks;
    }

    @Nullable
    public static ItemStack getOptimalWalkieTalkieRange(Player player) {
        ArrayList<ItemStack> itemStacks = Util.getWalkieTalkies(player);
        if (itemStacks.isEmpty()) {
            return null;
        }
        ItemStack itemStack = null;
        int range = 0;
        for (ItemStack stack : itemStacks) {
            WalkieTalkieItem walkieTalkieItem;
            Item item = stack.m_41720_();
            if (!(item instanceof WalkieTalkieItem) || (walkieTalkieItem = (WalkieTalkieItem)item).getRange() <= range) continue;
            itemStack = stack;
            range = walkieTalkieItem.getRange();
        }
        return itemStack;
    }

    @Nullable
    public static ItemStack getWalkieTalkieActivated(Player player) {
        ItemStack stack = Util.getOptimalWalkieTalkieRange(player);
        if (stack != null && stack.m_41783_().m_128471_("walkietalkie.activate")) {
            return stack;
        }
        return null;
    }

    public static int loop(int value, int min, int max) {
        if (value > max) {
            value = min;
        } else if (value < min) {
            value = max;
        }
        return value;
    }
}

