/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.voice.common.Utils;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final ResourceLocation SLIDER_LOCATION = new ResourceLocation("textures/gui/slider.png");
    private static final ResourceLocation VOICE_ACTIVATION_SLIDER = new ResourceLocation("voicechat", "textures/gui/voice_activation_slider.png");
    private static final Component NO_ACTIVATION = Component.m_237115_((String)"message.voicechat.voice_activation.disabled").m_130940_(ChatFormatting.RED);
    private double micValue;

    public VoiceActivationSlider(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_(), Utils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.m_5695_();
    }

    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280260_(SLIDER_LOCATION, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 4, 200, 20, 0, this.getYTexturePos());
        int micWidth = (int)((double)(this.f_93618_ - 2) * this.micValue);
        guiGraphics.m_280218_(VOICE_ACTIVATION_SLIDER, this.m_252754_() + 1, this.m_252907_() + 1, 0, 0, micWidth, 18);
        guiGraphics.m_280260_(SLIDER_LOCATION, this.m_252754_() + (int)(this.f_93577_ * (double)(this.f_93618_ - 8)), this.m_252907_(), 8, 20, 4, 200, 20, 0, this.getYtexturePosHandle());
        int color = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        this.m_280372_(guiGraphics, minecraft.f_91062_, 2, color);
    }

    private int getYTexturePos() {
        return (this.m_93696_() && !this.f_93622_ && !this.m_93696_() ? 1 : 0) * 20;
    }

    private int getYtexturePosHandle() {
        return (!this.f_93622_ && !this.m_93696_() ? 2 : 3) * 20;
    }

    protected void m_5695_() {
        long db = Math.round(Utils.percToDb(this.f_93577_));
        MutableComponent component = Component.m_237110_((String)"message.voicechat.voice_activation", (Object[])new Object[]{db});
        if (db >= -10L) {
            component.m_130940_(ChatFormatting.RED);
        }
        this.m_93666_((Component)component);
    }

    @Nullable
    public Component getHoverText() {
        if (this.f_93577_ >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    public boolean m_274382_() {
        return this.f_93622_;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(Utils.percToDb(this.f_93577_)).save();
    }

    @Override
    public void onMicValue(double percentage) {
        this.micValue = percentage;
    }
}

