/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.taczadditions.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.raiiiden.taczadditions.config.TacZAdditionsConfig;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BedrockGunModel.class}, remap=false)
public class MagazineTextOverlayMixin {
    private static final Map<ItemStack, List<Float>> recentDistances = new WeakHashMap<ItemStack, List<Float>>();
    private static final Map<ItemStack, Float> idleDistances = new WeakHashMap<ItemStack, Float>();
    private static final Map<ItemStack, Boolean> activated = new WeakHashMap<ItemStack, Boolean>();
    private static final Map<ItemStack, Float> maxDistances = new WeakHashMap<ItemStack, Float>();

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void injectText(PoseStack poseStack, ItemStack gunItem, ItemDisplayContext context, RenderType renderType, int light, int overlay, CallbackInfo ci) {
        float idle;
        float max;
        BedrockPart basePart;
        if (!((Boolean)TacZAdditionsConfig.CLIENT.magazineText.get()).booleanValue()) {
            return;
        }
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunItem);
        if (iGun == null) {
            return;
        }
        BedrockGunModel model = (BedrockGunModel)this;
        BedrockPart magPart = this.getPartByName(model.getRootNode(), "bullet_in_mag");
        if (magPart == null) {
            String[] fallbacks;
            for (String name : fallbacks = new String[]{"mag_and_lefthand", "lefthand_and_mag", "mag_and_lh", "mag_extended_1", "mag_extended_2", "mag_extended_3", "mag_standard"}) {
                magPart = this.getPartByName(model.getRootNode(), name);
                if (magPart != null) break;
            }
        }
        if ((basePart = this.getPartByName(model.getRootNode(), "gun_and_righthand")) == null) {
            String[] fallbacks;
            for (String name : fallbacks = new String[]{"righthand_and_gun", "gun", "gun_body", "body", "mag_release", "magrelease", "righthand", "righthand_pos"}) {
                basePart = this.getPartByName(model.getRootNode(), name);
                if (basePart != null) break;
            }
        }
        if (magPart == null || basePart == null) {
            return;
        }
        int ammo = iGun.getCurrentAmmoCount(gunItem);
        if (ammo < 0) {
            return;
        }
        float currentDist = this.getDistanceBetweenParts(magPart, basePart);
        List history = recentDistances.computeIfAbsent(gunItem, k -> new ArrayList());
        Boolean isActivated = activated.getOrDefault(gunItem, false);
        if (!isActivated.booleanValue()) {
            if (history.size() < 10) {
                history.add(Float.valueOf(currentDist));
                return;
            }
            float avg = 0.0f;
            Iterator iterator = history.iterator();
            while (iterator.hasNext()) {
                float f = ((Float)iterator.next()).floatValue();
                avg += f;
            }
            idleDistances.put(gunItem, Float.valueOf(avg /= (float)history.size()));
            maxDistances.put(gunItem, Float.valueOf(currentDist));
            if (Math.abs(currentDist - avg) > 0.3f) {
                activated.put(gunItem, true);
            } else {
                return;
            }
        }
        if (currentDist > (max = maxDistances.getOrDefault(gunItem, Float.valueOf((idle = idleDistances.getOrDefault(gunItem, Float.valueOf(1.0f)).floatValue()) + 0.01f)).floatValue())) {
            maxDistances.put(gunItem, Float.valueOf(currentDist));
            max = currentDist;
        }
        float percent = max != idle ? (currentDist - idle) / (max - idle) : 0.0f;
        if ((percent = Math.max(0.0f, Math.min(1.0f, percent))) < 0.05f) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        poseStack.m_85836_();
        this.applyCompleteTransformChain(poseStack, magPart);
        poseStack.m_252880_(0.0f, -0.05f, 0.1f);
        poseStack.m_85841_(0.01115f, -0.01115f, 0.0115f);
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f magDir = this.getPartDirection(magPart);
        Vector3f magDirNorm = new Vector3f((Vector3fc)magDir).normalize();
        float angle = (float)Math.toDegrees(Math.acos(normal.dot((Vector3fc)magDirNorm)));
        if (magDir.x < 0.0f) {
            angle = -angle;
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-angle));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        String ammoText = String.valueOf(ammo);
        float textWidth = (float)font.m_92895_(ammoText) * 0.5f;
        font.m_271703_(ammoText, -textWidth, -4.0f, 65280, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, light);
        poseStack.m_85849_();
        bufferSource.m_109911_();
    }

    private float getDistanceBetweenParts(BedrockPart a, BedrockPart b) {
        Vector3f apos = this.getAnimatedPosition(a);
        Vector3f bpos = this.getAnimatedPosition(b);
        return apos.sub((Vector3fc)bpos).length();
    }

    private Vector3f getAnimatedPosition(BedrockPart part) {
        PoseStack stack = new PoseStack();
        this.applyCompleteTransformChain(stack, part);
        Matrix4f mat = stack.m_85850_().m_252922_();
        Vector3f out = new Vector3f();
        mat.getTranslation(out);
        return out;
    }

    private void applyCompleteTransformChain(PoseStack stack, BedrockPart part) {
        for (BedrockPart p : this.getTransformChain(part)) {
            p.translateAndRotateAndScale(stack);
        }
    }

    private List<BedrockPart> getTransformChain(BedrockPart part) {
        ArrayList<BedrockPart> chain = new ArrayList<BedrockPart>();
        while (part != null) {
            chain.add(part);
            part = part.getParent();
        }
        Collections.reverse(chain);
        return chain;
    }

    private Vector3f getPartDirection(BedrockPart part) {
        PoseStack stack = new PoseStack();
        this.applyCompleteTransformChain(stack, part);
        Matrix4f mat = stack.m_85850_().m_252922_();
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        mat.transformDirection(up);
        return up;
    }

    private BedrockPart getPartByName(BedrockPart root, String name) {
        if (root == null) {
            return null;
        }
        if (name.equals(root.name)) {
            return root;
        }
        for (BedrockPart child : root.children) {
            BedrockPart found = this.getPartByName(child, name);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

