/*
 * Decompiled with CFR 0.152.
 */
package com.raiiiden.taczadditions.mixin;

import com.raiiiden.taczadditions.config.TacZAdditionsConfig;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.event.CameraSetupEvent;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.ViewportEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CameraSetupEvent.class})
public class CameraSetupEventMixin {
    private static float swayTimer = 0.0f;
    private static long crouchStartTime = 0L;
    private static long crouchCooldownEnd = 0L;
    private static final Random rand = new Random();

    @Inject(method={"applyLevelCameraAnimation"}, at={@At(value="TAIL")}, remap=false)
    private static void injectScopeSway(ViewportEvent.ComputeCameraAngles event, CallbackInfo ci) {
        if (!((Boolean)TacZAdditionsConfig.CLIENT.enableScopeSway.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack main = player.m_21205_();
        Item item = main.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        float zoom = iGun.getAimingZoom(main);
        float minZoom = ((Double)TacZAdditionsConfig.CLIENT.scopeSwayMinZoom.get()).floatValue();
        if (zoom < minZoom) {
            return;
        }
        IClientPlayerGunOperator op = IClientPlayerGunOperator.fromLocalPlayer((LocalPlayer)player);
        float aim = op.getClientAimingProgress(Minecraft.m_91087_().m_91296_());
        if (aim < 0.95f) {
            return;
        }
        float baseStrength = ((Double)TacZAdditionsConfig.CLIENT.scopeSwayStrength.get()).floatValue();
        float baseSpeed = ((Double)TacZAdditionsConfig.CLIENT.scopeSwaySpeed.get()).floatValue();
        float delta = Minecraft.m_91087_().m_91297_();
        swayTimer += delta;
        long now = System.currentTimeMillis();
        boolean crouching = player.m_6047_();
        float swayMult = 1.0f;
        float speedMult = 1.0f;
        long stabilizeMs = ((Double)TacZAdditionsConfig.CLIENT.crouchStabilizeTime.get()).longValue();
        long sporadicMs = ((Double)TacZAdditionsConfig.CLIENT.crouchSporadicTime.get()).longValue();
        long cooldownMs = ((Double)TacZAdditionsConfig.CLIENT.crouchCooldownTime.get()).longValue();
        double sporadicStrength = (Double)TacZAdditionsConfig.CLIENT.sporadicSwayStrength.get();
        double sporadicSpeed = (Double)TacZAdditionsConfig.CLIENT.sporadicSwaySpeed.get();
        if (crouching && now >= crouchCooldownEnd) {
            long crouchDuration;
            if (crouchStartTime == 0L) {
                crouchStartTime = now;
            }
            if ((crouchDuration = now - crouchStartTime) <= stabilizeMs) {
                swayMult = 0.25f;
            } else if (crouchDuration <= stabilizeMs + sporadicMs) {
                swayMult = (float)sporadicStrength;
                speedMult = (float)sporadicSpeed;
            } else {
                crouchCooldownEnd = now + cooldownMs;
                crouchStartTime = 0L;
            }
        } else {
            crouchStartTime = 0L;
        }
        float time = swayTimer / (baseSpeed * speedMult) * (float)Math.PI * 2.0f;
        float pitch = (float)Math.sin(time * 0.7f) * baseStrength * swayMult;
        float yaw = (float)Math.sin(time * 0.45f + 1.3f) * baseStrength * swayMult;
        player.m_146926_(player.m_146909_() + pitch);
        player.m_146922_(player.m_146908_() + yaw);
    }
}

