/*
 * Decompiled with CFR 0.152.
 */
package me.muksc.tacztweaks.network.message;

import com.tacz.guns.api.item.IGun;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import java.util.function.Supplier;
import me.muksc.tacztweaks.AbstractGunItemExtension;
import me.muksc.tacztweaks.Config;
import me.muksc.tacztweaks.ShooterDataHolderProvider;
import me.muksc.tacztweaks.TaCZTweaks;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClientMessagePlayerUnload {
    public static void encode(ClientMessagePlayerUnload message, FriendlyByteBuf buf) {
    }

    public static ClientMessagePlayerUnload decode(FriendlyByteBuf buf) {
        return new ClientMessagePlayerUnload();
    }

    public static void handle(ClientMessagePlayerUnload message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (!context.getDirection().getReceptionSide().isServer() || !Config.Gun.INSTANCE.allowUnload()) {
            context.setPacketHandled(true);
            return;
        }
        context.enqueueWork(() -> {
            ServerPlayer player2 = context.getSender();
            if (player2 == null) {
                return;
            }
            ShooterDataHolder data = ((ShooterDataHolderProvider)player2).tacztweaks$getShooterDataHolder();
            if (data.currentGunItem == null) {
                return;
            }
            ItemStack gunStack = (ItemStack)data.currentGunItem.get();
            IGun gun = IGun.getIGunOrNull((ItemStack)gunStack);
            if (gun == null) {
                return;
            }
            if (gun instanceof AbstractGunItemExtension) {
                AbstractGunItemExtension ext = (AbstractGunItemExtension)gun;
                ext.tacztweaks$setUnloading();
            }
            gun.dropAllAmmo((Player)player2, gunStack);
            player2.m_5661_((Component)TaCZTweaks.translatable("unload.done", new Object[0]), true);
        });
        context.setPacketHandled(true);
    }
}

