/*
 * Decompiled with CFR 0.152.
 */
package me.muksc.tacztweaks.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.util.block.BlockRayTrace;
import javax.annotation.Nullable;
import me.muksc.tacztweaks.BulletRayTracer;
import me.muksc.tacztweaks.mixin.accessor.ClipContextAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockRayTrace.class}, remap=false)
public abstract class BlockRayTraceMixin {
    @Unique
    private static BulletRayTracer tacztweaks$rayTracer = null;

    @Inject(method={"rayTraceBlocks"}, at={@At(value="HEAD")})
    private static void tacztweaks$rayTraceBlocks$initRayTracer(Level level, ClipContext context, CallbackInfoReturnable<BlockHitResult> cir) {
        tacztweaks$rayTracer = null;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClipContextAccessor accessor = (ClipContextAccessor)context;
        CollisionContext collisionContext = accessor.getCollisionContext();
        if (!(collisionContext instanceof EntityCollisionContext)) {
            return;
        }
        EntityCollisionContext entityCollisionContext = (EntityCollisionContext)collisionContext;
        Entity entity = entityCollisionContext.m_193113_();
        if (!(entity instanceof EntityKineticBullet)) {
            return;
        }
        EntityKineticBullet entity2 = (EntityKineticBullet)entity;
        tacztweaks$rayTracer = new BulletRayTracer(entity2, serverLevel, context);
    }

    @ModifyReturnValue(method={"lambda$rayTraceBlocks$1"}, at={@At(value="RETURN")})
    private static BlockHitResult tacztweaks$rayTraceBlocks$handle(@Nullable BlockHitResult original, @Local(argsOnly=true) ClipContext context, @Local(argsOnly=true) BlockPos blockPos, @Nullable @Local BlockState blockState) {
        if (tacztweaks$rayTracer == null) {
            return original;
        }
        if (original == null || original.m_6662_() == HitResult.Type.MISS) {
            return original;
        }
        if (blockState == null || blockState.m_60795_()) {
            return original;
        }
        return tacztweaks$rayTracer.handle(original, blockState);
    }

    @ModifyReturnValue(method={"lambda$rayTraceBlocks$2"}, at={@At(value="RETURN")})
    private static BlockHitResult tacztweaks$rayTraceBlocks$handleMiss(BlockHitResult original) {
        if (tacztweaks$rayTracer == null) {
            return original;
        }
        return tacztweaks$rayTracer.handle(original, null);
    }
}

