/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class TraceTool {
    public static boolean laserHeadshot = false;

    public static Entity findLookingEntity(Entity entity, double entityReach) {
        AABB aabb;
        double blockReach;
        double distance = entityReach * entityReach;
        Vec3 eyePos = entity.m_20299_(1.0f);
        HitResult hitResult = entity.m_19907_(entityReach, 1.0f, false);
        if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = hitResult.m_82450_().m_82557_(eyePos)) > (blockReach = 5.0) * blockReach) {
            Vec3 pos = hitResult.m_82450_();
            hitResult = BlockHitResult.m_82426_((Vec3)pos, (Direction)Direction.m_122366_((double)eyePos.f_82479_, (double)eyePos.f_82480_, (double)eyePos.f_82481_), (BlockPos)BlockPos.m_274446_((Position)pos));
        }
        Vec3 viewVec = entity.m_20252_(1.0f);
        Vec3 toVec = eyePos.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_() && entity.m_20202_() != p && p.m_6084_() && SeekTool.smokeFilter(p), (double)distance);
        if (entityhitresult != null) {
            Vec3 targetPos = entityhitresult.m_82450_();
            double distanceToTarget = eyePos.m_82557_(targetPos);
            if (distanceToTarget > distance || distanceToTarget > entityReach * entityReach) {
                hitResult = BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)viewVec.f_82479_, (double)viewVec.f_82480_, (double)viewVec.f_82481_), (BlockPos)BlockPos.m_274446_((Position)targetPos));
            } else if (distanceToTarget < distance) {
                hitResult = entityhitresult;
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).m_82443_();
        }
        return null;
    }

    public static Entity findMeleeEntity(Entity entity, double entityReach) {
        AABB aabb;
        double distance = entityReach * entityReach;
        Vec3 eyePos = entity.m_20299_(1.0f);
        HitResult hitResult = entity.m_19907_(entityReach, 1.0f, false);
        Vec3 viewVec = entity.m_20252_(1.0f);
        Vec3 toVec = eyePos.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_() && entity.m_20202_() != p && p.m_6084_(), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).m_82443_();
        }
        return null;
    }

    public static Entity laserfindLookingEntity(Entity player, double entityReach) {
        AABB aabb;
        double distance = entityReach * entityReach;
        Vec3 eyePos = player.m_20299_(1.0f);
        HitResult hitResult = player.m_19907_(entityReach, 1.0f, false);
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 toVec = eyePos.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = player.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_() && player.m_20202_() != p && p.m_6084_() && SeekTool.smokeFilter(p), (double)distance);
        if (entityhitresult != null) {
            Vec3 hitVec = entityhitresult.m_82450_();
            if (TraceTool.checkNoClip(player, hitVec)) {
                hitResult = entityhitresult;
            }
            if (hitResult.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)hitResult).m_82443_().m_6084_()) {
                LivingEntity living;
                Entity entity = ((EntityHitResult)hitResult).m_82443_();
                laserHeadshot = entity instanceof LivingEntity ? (living = (LivingEntity)entity).m_20188_() - 0.4 < hitVec.f_82480_ && hitVec.f_82480_ < living.m_20188_() + 0.5 : false;
                return ((EntityHitResult)hitResult).m_82443_();
            }
        }
        return null;
    }

    public static boolean checkNoClip(Entity entity, Vec3 target) {
        return entity.m_9236_().m_45547_(new ClipContext(entity.m_146892_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() != HitResult.Type.BLOCK;
    }

    public static Vec3 vehicleFindLookingPos(Projectile projectile, VehicleEntity vehicle, Vec3 eye, double entityReach) {
        AABB aabb;
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(eye, 512.0, vehicle);
        Vec3 viewVec = vehicle.getBarrelVector(1.0f);
        Vec3 toVec = eye.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)vehicle, (Vec3)eye, (Vec3)toVec, (AABB)(aabb = vehicle.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_() && p.m_6084_() && SeekTool.baseFilter(p) && !p.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) && SeekTool.smokeFilter(p) && p != projectile, (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return hitResult.m_82450_();
        }
        return null;
    }

    public static Vec3 playerFindLookingPos(Player player, Entity entity, double entityReach) {
        double distance = entityReach * entityReach;
        HitResult hitResult = player.m_19907_(entityReach, 1.0f, false);
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 toVec = player.m_146892_().m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        AABB aabb = entity.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityhitresult = ProjectileUtil.m_150175_((Level)player.m_9236_(), (Entity)player, (Vec3)player.m_146892_(), (Vec3)toVec, (AABB)aabb, p -> true, (float)((float)distance));
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return hitResult.m_82450_();
        }
        return null;
    }

    public static Entity droneFindLookingEntity(Entity entity, Vec3 pos, double entityReach, float ticks) {
        AABB aabb;
        double distance = entityReach * entityReach;
        HitResult hitResult = entity.m_19907_(entityReach, 1.0f, false);
        Vec3 viewVec = entity.m_20252_(ticks);
        Vec3 toVec = pos.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = entity.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_() && p.m_6084_() && !(p instanceof Projectile) && SeekTool.baseFilter(p) && !p.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) && SeekTool.smokeFilter(p) && p != entity && p != entity.m_20202_(), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).m_82443_();
        }
        return null;
    }

    public static Entity camerafFindLookingEntity(Player player, Vec3 pos, Vec3 viewVec, double entityReach) {
        AABB aabb;
        Vec3 toVec;
        EntityHitResult entityhitresult;
        double blockReach;
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(pos, entityReach, viewVec, (Entity)player);
        if (hitResult.m_6662_() != HitResult.Type.MISS && (distance = hitResult.m_82450_().m_82557_(pos)) > (blockReach = 5.0) * blockReach) {
            hitResult = BlockHitResult.m_82426_((Vec3)hitResult.m_82450_(), (Direction)Direction.m_122366_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_), (BlockPos)BlockPos.m_274446_((Position)hitResult.m_82450_()));
        }
        if ((entityhitresult = ProjectileUtil.m_37287_((Entity)player, (Vec3)pos, (Vec3)(toVec = pos.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach)), (AABB)(aabb = player.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82377_(1.0, 1.0, 1.0)), p -> !p.m_5833_() && p.m_6084_() && !(p instanceof Projectile) && SeekTool.baseFilter(p) && !p.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) && SeekTool.smokeFilter(p) && p != player && p != player.m_20202_(), (double)distance)) != null) {
            Vec3 targetPos = entityhitresult.m_82450_();
            double distanceToTarget = pos.m_82557_(targetPos);
            if (distanceToTarget > distance || distanceToTarget > entityReach * entityReach) {
                hitResult = BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)viewVec.f_82479_, (double)viewVec.f_82480_, (double)viewVec.f_82481_), (BlockPos)BlockPos.m_274446_((Position)targetPos));
            } else if (distanceToTarget < distance) {
                hitResult = entityhitresult;
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).m_82443_();
        }
        return null;
    }

    public static HitResult pickNew(Vec3 pos, double pHitDistance, VehicleEntity vehicle) {
        Vec3 vec31 = vehicle.getBarrelVector(1.0f);
        Vec3 vec32 = pos.m_82520_(vec31.f_82479_ * pHitDistance, vec31.f_82480_ * pHitDistance, vec31.f_82481_ * pHitDistance);
        return vehicle.m_9236_().m_45547_(new ClipContext(pos, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)vehicle));
    }

    public static HitResult pickNew(Vec3 pos, double pHitDistance, Vec3 viewVec, Entity entity) {
        Vec3 vec32 = pos.m_82520_(viewVec.f_82479_ * pHitDistance, viewVec.f_82480_ * pHitDistance, viewVec.f_82481_ * pHitDistance);
        return entity.m_9236_().m_45547_(new ClipContext(pos, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, entity));
    }

    public static List<BlockPos> getBlocksAlongRay(Vec3 start, Vec3 direction, double maxDistance) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        Vec3 normalizedDir = direction.m_82541_();
        Vec3 end = start.m_82549_(normalizedDir.m_82490_(maxDistance));
        double step = 0.1;
        BlockPos lastPos = null;
        for (double distance = 0.0; distance <= maxDistance; distance += step) {
            Vec3 currentPos = start.m_82549_(normalizedDir.m_82490_(distance));
            BlockPos blockPos = new BlockPos((int)Math.floor(currentPos.f_82479_), (int)Math.floor(currentPos.f_82480_), (int)Math.floor(currentPos.f_82481_));
            if (lastPos != null && lastPos.equals((Object)blockPos)) continue;
            blocks.add(blockPos);
            lastPos = blockPos;
        }
        return blocks;
    }

    public static List<RayTraceResultEntity> getEntitiesAlongVector(Level world, Vec3 start, Vec3 direction, double maxDistance, Predicate<Entity> filterPredicate) {
        ArrayList<RayTraceResultEntity> hitEntities = new ArrayList<RayTraceResultEntity>();
        Vec3 normalizedDirection = direction.m_82541_();
        Vec3 end = start.m_82549_(normalizedDirection.m_82490_(maxDistance));
        AABB rayBoundingBox = new AABB(start, end).m_82400_(1.0);
        List entitiesInWorld = world.m_6249_((Entity)null, rayBoundingBox, filterPredicate);
        for (Entity entity : entitiesInWorld) {
            if (entity instanceof PartEntity) continue;
            AABB entityBoundingBox = entity.m_20191_();
            Double distanceToHit = TraceTool.rayIntersectsAABB(start, normalizedDirection, entityBoundingBox = entityBoundingBox.m_82400_(0.3), maxDistance);
            if (distanceToHit == null) continue;
            Vec3 hitVec = start.m_82549_(normalizedDirection.m_82490_(distanceToHit.doubleValue()));
            hitEntities.add(new RayTraceResultEntity(entity, distanceToHit, hitVec));
        }
        hitEntities.sort(Comparator.comparingDouble(o -> o.distance));
        return hitEntities;
    }

    private static Double rayIntersectsAABB(Vec3 start, Vec3 dir, AABB box, double maxDist) {
        double tMin = 0.0;
        double tMax = maxDist;
        double invDx = 1.0 / dir.f_82479_;
        double t0x = (box.f_82288_ - start.f_82479_) * invDx;
        double t1x = (box.f_82291_ - start.f_82479_) * invDx;
        if (invDx < 0.0) {
            double temp = t0x;
            t0x = t1x;
            t1x = temp;
        }
        tMin = Math.max(tMin, t0x);
        if ((tMax = Math.min(tMax, t1x)) <= tMin) {
            return null;
        }
        double invDy = 1.0 / dir.f_82480_;
        double t0y = (box.f_82289_ - start.f_82480_) * invDy;
        double t1y = (box.f_82292_ - start.f_82480_) * invDy;
        if (invDy < 0.0) {
            double temp = t0y;
            t0y = t1y;
            t1y = temp;
        }
        tMin = Math.max(tMin, t0y);
        if ((tMax = Math.min(tMax, t1y)) <= tMin) {
            return null;
        }
        double invDz = 1.0 / dir.f_82481_;
        double t0z = (box.f_82290_ - start.f_82481_) * invDz;
        double t1z = (box.f_82293_ - start.f_82481_) * invDz;
        if (invDz < 0.0) {
            double temp = t0z;
            t0z = t1z;
            t1z = temp;
        }
        tMin = Math.max(tMin, t0z);
        if ((tMax = Math.min(tMax, t1z)) <= tMin) {
            return null;
        }
        return tMin;
    }

    public static class RayTraceResultEntity {
        public final Entity entity;
        public final double distance;
        public final Vec3 hitVec;

        public RayTraceResultEntity(Entity entity, double distance, Vec3 hitVec) {
            this.entity = entity;
            this.distance = distance;
            this.hitVec = hitVec;
        }

        public String toString() {
            return "RayTraceResultEntity{entity=" + this.entity + ", distance=" + this.distance + ", hitVec=" + this.hitVec + "}";
        }
    }
}

