/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.config.server.SeekConfig;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.SwarmDroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SeekTool {
    public static List<Entity> getVehicleWithinRange(Player player, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> e.m_20182_().m_82554_(player.m_146892_()) <= range && e instanceof MobileVehicleEntity).toList();
    }

    public static List<Entity> getEntityWithinRange(Player player, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> e.m_20182_().m_82554_(player.m_146892_()) <= range).toList();
    }

    public static List<Entity> getEntityWithinRange(Entity entity, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> e.m_20182_().m_82554_(entity.m_146892_()) <= range).toList();
    }

    public static List<Entity> getTeammate(Player player, Level level) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> SeekTool.friendlyToPlayer((Entity)player, e)).toList();
    }

    public static boolean friendlyToPlayer(Entity e, Entity entity) {
        Player player;
        OwnableEntity ownableEntity;
        if (SeekTool.teamFilter(e, entity)) {
            return true;
        }
        if (entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).m_269323_() != null && SeekTool.teamFilter(e, (Entity)ownableEntity.m_269323_())) {
            return true;
        }
        if (e instanceof Player && SeekTool.teammateDrone(entity, player = (Player)e)) {
            return true;
        }
        List entities = entity.m_20197_();
        for (Entity passenger : entities) {
            if (!SeekTool.teamFilter(e, passenger)) continue;
            return true;
        }
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            Entity lastDriver = EntityFindUtil.findEntity(vehicle.m_9236_(), (String)vehicle.m_20088_().m_135370_(VehicleEntity.LAST_DRIVER_UUID));
            return lastDriver != null && SeekTool.teamFilter(e, lastDriver);
        }
        return false;
    }

    public static boolean teamFilter(Entity e, Entity entity) {
        if (e == null) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        return e == entity || entity.m_5647_() != null && !entity.m_5647_().m_5758_().equals("TDM") && entity.m_5647_() == e.m_5647_();
    }

    public static boolean teammateDrone(Entity e, Player player) {
        DroneEntity drone;
        ItemStack stack = player.m_21205_();
        DroneEntity drone2 = null;
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using") && stack.m_41784_().m_128471_("Linked")) {
            drone2 = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_("LinkedDrone"));
        }
        return e instanceof DroneEntity && (drone = (DroneEntity)e) != drone2 && drone.getController() != null && SeekTool.teamFilter(e, drone.getController());
    }

    public static Entity seekEntity(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> {
            if ((double)e.m_20270_(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.m_20202_() == null) {
                return level.m_45547_(new ClipContext(entity.m_146892_(), e.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    public static Entity seekCustomSizeEntity(Entity entity, Level level, double seekRange, double seekAngle, double size, boolean checkOnGround) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> {
            if ((double)e.m_20270_(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && (!checkOnGround || SeekTool.isOnGround(e, 10.0)) && e.m_20191_().m_82309_() >= size && SeekTool.smokeFilter(e) && e.m_20202_() == null) {
                return level.m_45547_(new ClipContext(entity.m_146892_(), e.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    public static Entity seekLivingEntity(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> {
            SwarmDroneEntity swarmDrone;
            if ((double)e.m_20270_(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.m_20202_() == null && (!(e instanceof SwarmDroneEntity) || (swarmDrone = (SwarmDroneEntity)e).m_19749_() == entity) && !SeekTool.friendlyToPlayer(entity, e)) {
                return level.m_45547_(new ClipContext(entity.m_146892_(), e.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    public static List<Entity> seekLivingEntities(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> {
            if ((double)e.m_20270_(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.m_20202_() == null && !SeekTool.friendlyToPlayer(entity, e)) {
                return level.m_45547_(new ClipContext(entity.m_146892_(), e.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() != HitResult.Type.BLOCK;
            }
            return false;
        }).toList();
    }

    public static List<Entity> seekCustomSizeEntities(Entity entity, Level level, double seekRange, double seekAngle, double size, boolean checkOnGround) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> {
            if ((double)e.m_20270_(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && e.m_20191_().m_82309_() >= size && SeekTool.baseFilter(e) && (!checkOnGround || SeekTool.isOnGround(e, 10.0)) && SeekTool.smokeFilter(e) && e.m_20202_() == null && !SeekTool.friendlyToPlayer(entity, e)) {
                return level.m_45547_(new ClipContext(entity.m_146892_(), e.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() != HitResult.Type.BLOCK;
            }
            return false;
        }).toList();
    }

    public static Entity vehicleSeekEntity(VehicleEntity vehicle, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> {
            if ((double)e.m_20270_((Entity)vehicle) <= seekRange && SeekTool.calculateAngleVehicle(e, vehicle) < seekAngle && e != vehicle && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.m_20202_() == null && !SeekTool.friendlyToPlayer(vehicle, e)) {
                return level.m_45547_(new ClipContext(vehicle.getNewEyePos(1.0f), vehicle.getNewEyePos(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)vehicle)).m_6662_() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngleVehicle(e, vehicle))).orElse(null);
    }

    public static List<Entity> seekLivingEntitiesThroughWall(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> (double)e.m_20270_(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && e.m_20202_() == null && !SeekTool.friendlyToPlayer(entity, e)).toList();
    }

    public static Entity seekEntityThroughWall(Entity entity, Level level, double seekRange, double seekAngle) {
        return SeekTool.seekLivingEntitiesThroughWall(entity, level, seekRange, seekAngle).stream().min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    public static List<Entity> getEntitiesWithinRange(BlockPos pos, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).m_142273_().spliterator(), false).filter(e -> e.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= range * range && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && !e.m_6095_().m_204039_(ModTags.EntityTypes.DECOY)).toList();
    }

    private static double calculateAngle(Entity entityA, Entity entityB) {
        Vec3 start = new Vec3(entityA.m_20185_() - entityB.m_20185_(), entityA.m_20186_() - entityB.m_20186_(), entityA.m_20189_() - entityB.m_20189_());
        Vec3 end = entityB.m_20154_();
        return VectorTool.calculateAngle(start, end);
    }

    private static double calculateAngleVehicle(Entity entityA, VehicleEntity entityB) {
        Vec3 entityBEyePos = entityB.getNewEyePos(1.0f);
        Vec3 start = new Vec3(entityA.m_20185_() - entityBEyePos.f_82479_, entityA.m_20186_() - entityBEyePos.f_82480_, entityA.m_20189_() - entityBEyePos.f_82481_);
        Vec3 end = entityB.getBarrelVector(1.0f);
        return VectorTool.calculateAngle(start, end);
    }

    public static boolean baseFilter(Entity entity) {
        Player player;
        return !(!entity.m_6084_() || entity instanceof HangingEntity || entity instanceof Projectile && !entity.m_6095_().m_204039_(ModTags.EntityTypes.DESTROYABLE_PROJECTILE) || entity instanceof Player && (player = (Player)entity).m_5833_() || SeekTool.isInBlackList(entity));
    }

    public static boolean isOnGround(Entity entity) {
        return SeekTool.isOnGround(entity, 0.0);
    }

    public static boolean isOnGround(Entity entity, double height) {
        Level level = entity.m_9236_();
        double y = entity.m_20186_();
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        if (y < (double)minY || y > (double)maxY) {
            return false;
        }
        boolean[] onGround = new boolean[]{false};
        AABB aabb = entity.m_20191_().m_82363_(0.0, -height, 0.0);
        BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
            if (pos.m_123342_() < minY || pos.m_123342_() > maxY) {
                return;
            }
            BlockState state = level.m_8055_(pos);
            if (!state.m_60795_()) {
                onGround[0] = true;
            }
        });
        return entity.m_20096_() || entity.m_20069_() || onGround[0];
    }

    public static boolean smokeFilter(Entity pEntity) {
        AABB Box = pEntity.m_20191_().m_82400_(8.0);
        List entities = pEntity.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), Box, entity -> entity instanceof SmokeDecoyEntity).stream().toList();
        boolean result = true;
        for (Entity e : entities) {
            if (e == null) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isInBlackList(Entity entity) {
        ResourceLocation type = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (type == null) {
            return false;
        }
        return ((List)SeekConfig.SEEK_BLACKLIST.get()).contains(type.toString());
    }
}

