/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RangeTool {
    private static final double TOLERANCE = 0.001;
    private static final int MAX_ITERATIONS = 50;

    public static double getRange(double thetaDegrees, double v, double g) {
        double t = v * Math.sin(thetaDegrees * 0.01745329238474369) / g * 2.0;
        return t * v * Math.cos(thetaDegrees * 0.01745329238474369);
    }

    @Nullable
    public static Vec3 calculateLaunchVector(Vec3 pos, Vec3 pos2, double velocity, double gravity, boolean isDepressed) {
        double g = -gravity;
        double dy = pos2.f_82480_ - pos.f_82480_;
        double b = -velocity * velocity - g * dy;
        double a = 0.25 * g * g;
        double dx = pos2.f_82479_ - pos.f_82479_;
        double dz = pos2.f_82481_ - pos.f_82481_;
        double horizontalDistSq = dx * dx + dz * dz;
        double c = horizontalDistSq + dy * dy;
        List<Double> validT = RangeTool.getDoubles(b, a, c);
        if (validT.isEmpty()) {
            return null;
        }
        double t = isDepressed ? Collections.min(validT).doubleValue() : Collections.max(validT).doubleValue();
        double vx = dx / t;
        double vz = dz / t;
        double vy = (dy - 0.5 * g * t * t) / t;
        return new Vec3(vx, vy, vz);
    }

    private static List<Double> getDoubles(double b, double a, double c) {
        double discriminant = b * b - 4.0 * a * c;
        if (discriminant < 0.0) {
            return List.of();
        }
        double sqrtDisc = Math.sqrt(discriminant);
        double u1 = (-b + sqrtDisc) / (2.0 * a);
        double u2 = (-b - sqrtDisc) / (2.0 * a);
        ArrayList<Double> validT = new ArrayList<Double>();
        if (u1 > 0.0) {
            validT.add(Math.sqrt(u1));
        }
        if (u2 > 0.0) {
            validT.add(Math.sqrt(u2));
        }
        return validT;
    }

    public static Vec3 calculateFiringSolution(Vec3 launchPos, Vec3 targetPos, Vec3 targetVel, double muzzleVelocity, double gravity) {
        double t2;
        double t3;
        double t4;
        double f;
        double t;
        Vec3 d0 = targetPos.m_82546_(launchPos);
        double dSqr = d0.m_82556_();
        double dot = d0.m_82526_(targetVel);
        double absSqr = targetVel.m_82556_();
        double a = 0.25 * gravity * gravity;
        double b = gravity * targetVel.f_82480_;
        double c = absSqr + gravity * d0.f_82480_ - muzzleVelocity * muzzleVelocity;
        double d = 2.0 * dot;
        double prevT = t = RangeTool.estimateInitialTime(d0, muzzleVelocity);
        for (int i = 0; i < 50 && !(Math.abs(f = a * (t4 = (t3 = (t2 = t * t) * t) * t) + b * t3 + c * t2 + d * t + dSqr) < 0.001); ++i) {
            double df = 4.0 * a * t3 + 3.0 * b * t2 + 2.0 * c * t + d;
            if (Math.abs(df) < 1.0E-10) {
                t = prevT + 0.1;
                continue;
            }
            prevT = t;
            if (!((t -= f / df) < 0.0)) continue;
            t = 0.1;
        }
        if (t > 0.0) {
            double invT = 1.0 / t;
            double vx = d0.f_82479_ * invT + targetVel.f_82479_;
            double vz = d0.f_82481_ * invT + targetVel.f_82481_;
            double vy = d0.f_82480_ * invT + targetVel.f_82480_ + 0.5 * gravity * t;
            return new Vec3(vx, vy, vz);
        }
        double fallbackT = Math.sqrt(dSqr) / muzzleVelocity;
        Vec3 predictedPos = targetPos.m_82549_(targetVel.m_82490_(fallbackT));
        Vec3 toPredicted = predictedPos.m_82546_(launchPos);
        double vy = (toPredicted.f_82480_ + 0.5 * gravity * fallbackT * fallbackT) / fallbackT;
        Vec3 horizontal = new Vec3(toPredicted.f_82479_, 0.0, toPredicted.f_82481_).m_82541_();
        double horizontalSpeed = Math.sqrt(muzzleVelocity * muzzleVelocity - vy * vy);
        return new Vec3(horizontal.f_82479_ * horizontalSpeed, vy, horizontal.f_82481_ * horizontalSpeed);
    }

    private static double estimateInitialTime(Vec3 d0, double velocity) {
        return d0.m_82553_() / velocity;
    }
}

