/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTTool {
    public static JsonObject convertToJson(CompoundTag nbt) {
        JsonObject json = new JsonObject();
        nbt.m_128431_().forEach(key -> {
            Tag tag = nbt.m_128423_(key);
            json.add(key, NBTTool.parseTag(tag));
        });
        return json;
    }

    public static JsonElement parseTag(Tag tag) {
        if (tag instanceof CompoundTag) {
            return NBTTool.convertToJson((CompoundTag)tag);
        }
        if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            JsonArray array = new JsonArray();
            list.forEach(element -> array.add(NBTTool.parseTag(element)));
            return array;
        }
        if (tag instanceof NumericTag) {
            NumericTag numeric = (NumericTag)tag;
            return new JsonPrimitive(numeric.m_8103_());
        }
        if (tag instanceof StringTag) {
            return new JsonPrimitive(tag.m_7916_());
        }
        if (tag instanceof ByteArrayTag) {
            byte[] bytes;
            ByteArrayTag byteArray = (ByteArrayTag)tag;
            JsonArray array = new JsonArray();
            for (byte b : bytes = byteArray.m_128227_()) {
                array.add((JsonElement)new JsonPrimitive((Number)b));
            }
            return array;
        }
        if (tag instanceof IntArrayTag) {
            int[] ints;
            IntArrayTag intArray = (IntArrayTag)tag;
            JsonArray array = new JsonArray();
            for (int i : ints = intArray.m_128648_()) {
                array.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return array;
        }
        if (tag instanceof LongArrayTag) {
            long[] longs;
            LongArrayTag longArray = (LongArrayTag)tag;
            JsonArray array = new JsonArray();
            for (long l : longs = longArray.m_128851_()) {
                array.add((JsonElement)new JsonPrimitive((Number)l));
            }
            return array;
        }
        if (tag instanceof EndTag) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(tag.toString());
    }
}

