/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.capability.ModCapabilities;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public enum Ammo {
    HANDGUN(ChatFormatting.GREEN),
    RIFLE(ChatFormatting.AQUA),
    SHOTGUN(ChatFormatting.RED),
    SNIPER(ChatFormatting.GOLD),
    HEAVY(ChatFormatting.LIGHT_PURPLE);

    public final String translationKey;
    public final String serializationName;
    public final String name;
    public final String displayName;
    public final ChatFormatting color;

    private Ammo(ChatFormatting color) {
        String name;
        this.color = color;
        this.name = name = this.name().toLowerCase(Locale.ROOT);
        this.translationKey = "item.superbwarfare.ammo." + name;
        StringBuilder builder = new StringBuilder();
        boolean useUpperCase = true;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                useUpperCase = true;
                continue;
            }
            if (useUpperCase) {
                builder.append(String.valueOf(c).toUpperCase(Locale.ROOT));
                useUpperCase = false;
                continue;
            }
            builder.append(c);
        }
        this.displayName = builder + " Ammo";
        this.serializationName = builder + "Ammo";
    }

    public static Ammo getType(String name) {
        for (Ammo type : Ammo.values()) {
            if (!type.serializationName.equals(name)) continue;
            return type;
        }
        return null;
    }

    public int get(ItemStack stack) {
        return this.get(stack.m_41784_());
    }

    public void set(ItemStack stack, int count) {
        this.set(stack.m_41784_(), count);
    }

    public void add(ItemStack stack, int count) {
        this.add(stack.m_41784_(), count);
    }

    public int get(CompoundTag tag) {
        return tag.m_128451_(this.serializationName);
    }

    public void set(CompoundTag tag, int count) {
        if (count < 0) {
            count = 0;
        }
        tag.m_128405_(this.serializationName, count);
    }

    public void add(CompoundTag tag, int count) {
        this.set(tag, this.safeAdd(this.get(tag), count));
    }

    public int get(Player player) {
        return player.getCapability(ModCapabilities.PLAYER_VARIABLE).map(this::get).orElse(0);
    }

    public void set(Player player, int count) {
        PlayerVariable.modify((Entity)player, c -> this.set((PlayerVariable)c, Math.max(0, count)));
    }

    public void add(Player player, int count) {
        this.set(player, this.safeAdd(this.get(player), count));
    }

    public int get(PlayerVariable variable) {
        return variable.ammo.getOrDefault((Object)this, 0);
    }

    public void set(PlayerVariable variable, int count) {
        if (count < 0) {
            count = 0;
        }
        variable.ammo.put(this, count);
    }

    public void add(PlayerVariable variable, int count) {
        this.set(variable, this.safeAdd(this.get(variable), count));
    }

    private int safeAdd(int a, int b) {
        long newCount = (long)a + (long)b;
        if (newCount > Integer.MAX_VALUE) {
            newCount = Integer.MAX_VALUE;
        } else if (newCount < 0L) {
            newCount = 0L;
        }
        return (int)newCount;
    }

    public String toString() {
        return this.serializationName;
    }
}

