/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.functional;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class HealClip
extends Perk {
    public HealClip() {
        super("heal_clip", Perk.Type.FUNCTIONAL);
    }

    @Override
    public void tick(GunData data, PerkInstance instance, @Nullable Entity entity) {
        data.perk.reduceCooldown(this, "HealClipTime");
    }

    @Override
    public void onKill(GunData data, PerkInstance instance, Entity target, DamageSource source) {
        short healClipLevel;
        if ((DamageTypeTool.isGunDamage(source) || source.m_276093_(ModDamageTypes.PROJECTILE_EXPLOSION)) && (healClipLevel = instance.level()) != 0) {
            data.perk.getTag(this).m_128405_("HealClipTime", 80 + healClipLevel * 20);
        }
    }

    @Override
    public void preReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
        int time = data.perk.getTag(this).m_128451_("HealClipTime");
        if (time > 0) {
            data.perk.getTag(this).m_128473_("HealClipTime");
            data.perk.getTag(this).m_128379_("HealClip", true);
        } else {
            data.perk.getTag(this).m_128473_("HealClip");
        }
    }

    @Override
    public void postReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!data.perk.getTag(this).m_128441_("HealClip")) {
            return;
        }
        short healClipLevel = instance.level();
        if (healClipLevel == 0) {
            healClipLevel = 1;
        }
        float healAmount = 12.0f * (0.8f + 0.2f * (float)healClipLevel);
        float absorption = healAmount - living.m_21233_() + living.m_21223_();
        living.m_5634_(healAmount);
        if (absorption > 0.0f) {
            living.m_7911_(absorption * 0.3f);
        }
        List<Player> players = entity.m_9236_().m_45976_(Player.class, entity.m_20191_().m_82400_(5.0)).stream().filter(p -> {
            OwnableEntity ownableEntity;
            return p.m_7307_(entity) || entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).m_269323_() == p;
        }).toList();
        short finalHealClipLevel = healClipLevel;
        players.forEach(p -> p.m_5634_(6.0f * (0.8f + 0.2f * (float)finalHealClipLevel)));
    }
}

