/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.damage;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class KillClip
extends Perk {
    public KillClip() {
        super("kill_clip", Perk.Type.DAMAGE);
        this.appendModification(GunProp.DAMAGE, (DATA data, T damage) -> data.perk.getTag(this).m_128451_("KillClipTime") > 0 ? damage * (1.2 + 0.05 * (double)data.perk.getLevel(this)) : damage);
    }

    @Override
    public void tick(GunData data, PerkInstance instance, @Nullable Entity entity) {
        data.perk.reduceCooldown(this, "KillClipReloadTime");
        data.perk.reduceCooldown(this, "KillClipTime");
    }

    @Override
    public void preReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
        int time = data.perk.getTag(this).m_128451_("KillClipReloadTime");
        if (time > 0) {
            data.perk.getTag(this).m_128473_("KillClipReloadTime");
            data.perk.getTag(this).m_128379_("KillClip", true);
        } else {
            data.perk.getTag(this).m_128473_("KillClip");
        }
    }

    @Override
    public void postReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
        if (!data.perk.getTag(this).m_128471_("KillClip")) {
            return;
        }
        short level = instance.level();
        data.perk.getTag(this).m_128405_("KillClipTime", 90 + 10 * level);
    }

    @Override
    public void onKill(GunData data, PerkInstance instance, Entity target, DamageSource source) {
        short killClipLevel;
        if ((DamageTypeTool.isGunDamage(source) || source.m_276093_(ModDamageTypes.PROJECTILE_EXPLOSION)) && (killClipLevel = instance.level()) != 0) {
            data.perk.getTag(this).m_128405_("KillClipReloadTime", 80);
        }
    }
}

