/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.damage;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class Desperado
extends Perk {
    public Desperado() {
        super("desperado", Perk.Type.DAMAGE);
        this.appendModification(GunProp.RPM, (DATA data, T rpm) -> {
            if (data.perk.getTag(this).m_128451_("DesperadoTimePost") > 0) {
                return (int)((double)rpm.intValue() * (1.285 + 0.015 * (double)data.perk.getLevel(this)));
            }
            return rpm;
        });
    }

    @Override
    public void tick(GunData data, PerkInstance instance, @Nullable Entity entity) {
        data.perk.reduceCooldown(this, "DesperadoTime");
        data.perk.reduceCooldown(this, "DesperadoTimePost");
    }

    @Override
    public void onKill(GunData data, PerkInstance instance, Entity target, DamageSource source) {
        if (DamageTypeTool.isHeadshotDamage(source)) {
            data.perk.getTag(this).m_128405_("DesperadoTime", 90 + instance.level() * 10);
        }
    }

    @Override
    public void preReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
        int time = data.perk.getTag(this).m_128451_("DesperadoTime");
        if (time > 0) {
            data.perk.getTag(this).m_128473_("DesperadoTime");
            data.perk.getTag(this).m_128379_("Desperado", true);
        } else {
            data.perk.getTag(this).m_128473_("Desperado");
        }
    }

    @Override
    public void postReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
        if (!data.perk.getTag(this).m_128471_("Desperado")) {
            return;
        }
        data.perk.getTag(this).m_128405_("DesperadoTimePost", 110 + instance.level() * 10);
    }
}

