/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.SeekTool;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class IglaSeekMessage {
    private final int type;

    public IglaSeekMessage(int type) {
        this.type = type;
    }

    public static IglaSeekMessage decode(FriendlyByteBuf buffer) {
        return new IglaSeekMessage(buffer.readInt());
    }

    public static void encode(IglaSeekMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
    }

    public static void handler(IglaSeekMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            CompoundTag tag;
            ItemStack handItem;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            if (message.type == 0 && player.m_21205_().m_41720_() == ModItems.IGLA.get()) {
                handItem = player.m_21205_();
                tag = handItem.m_41784_();
                GunData data = GunData.from(handItem);
                Entity seekingEntity = SeekTool.seekEntity((Entity)player, player.m_9236_(), 512.0, 20.0);
                Entity targetEntity = EntityFindUtil.findEntity(player.m_9236_(), tag.m_128461_("TargetEntity"));
                if (seekingEntity != null) {
                    if (data.hasEnoughAmmoToShoot((Entity)player)) {
                        tag.m_128359_("TargetEntity", seekingEntity.m_20149_());
                        tag.m_128379_("Seeking", true);
                        if (!tag.m_128471_("Seeking")) {
                            tag.m_128405_("SeekTime", 0);
                        }
                        if (seekingEntity != targetEntity) {
                            tag.m_128379_("Seeking", false);
                            tag.m_128405_("SeekTime", 0);
                            ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(new ResourceLocation("superbwarfare", "igla_9k38_lock"), SoundSource.PLAYERS);
                            player.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
                        }
                    }
                } else {
                    tag.m_128359_("TargetEntity", "none");
                }
            }
            if (message.type == 1 && player.m_21205_().m_41720_() == ModItems.IGLA.get()) {
                handItem = player.m_21205_();
                tag = handItem.m_41784_();
                tag.m_128379_("Seeking", false);
                tag.m_128405_("SeekTime", 0);
                tag.m_128359_("TargetEntity", "none");
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(new ResourceLocation("superbwarfare", "igla_9k38_lock"), SoundSource.PLAYERS);
                player.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
            }
        });
        context.setPacketHandled(true);
    }
}

