/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class FiringParametersEditMessage {
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int radius;
    private final boolean isDepressed;
    private final boolean mainHand;

    public FiringParametersEditMessage(int posX, int posY, int posZ, int radius, boolean isDepressed, boolean mainHand) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.radius = radius;
        this.isDepressed = isDepressed;
        this.mainHand = mainHand;
    }

    public static void encode(FiringParametersEditMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.posX);
        buffer.writeInt(message.posY);
        buffer.writeInt(message.posZ);
        buffer.writeInt(message.radius);
        buffer.writeBoolean(message.isDepressed);
        buffer.writeBoolean(message.mainHand);
    }

    public static FiringParametersEditMessage decode(FriendlyByteBuf buffer) {
        return new FiringParametersEditMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readBoolean(), buffer.readBoolean());
    }

    public static void handler(FiringParametersEditMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack itemStack = stack = message.mainHand ? player.m_21205_() : player.m_21206_();
            if (!stack.m_150930_((Item)ModItems.FIRING_PARAMETERS.get()) && !stack.m_150930_((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                return;
            }
            stack.m_41784_().m_128405_("TargetX", message.posX);
            stack.m_41784_().m_128405_("TargetY", message.posY);
            stack.m_41784_().m_128405_("TargetZ", message.posZ);
            stack.m_41784_().m_128405_("Radius", message.radius);
            stack.m_41784_().m_128379_("IsDepressed", message.isDepressed);
            Item patt2391$temp = stack.m_41720_();
            if (patt2391$temp instanceof ArtilleryIndicator) {
                ArtilleryIndicator indicator = (ArtilleryIndicator)patt2391$temp;
                indicator.setTarget(stack, (Player)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

