/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class AdjustZoomFovMessage {
    private final double scroll;

    public AdjustZoomFovMessage(double scroll) {
        this.scroll = scroll;
    }

    public static void encode(AdjustZoomFovMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeDouble(message.scroll);
    }

    public static AdjustZoomFovMessage decode(FriendlyByteBuf byteBuf) {
        return new AdjustZoomFovMessage(byteBuf.readDouble());
    }

    public static void handler(AdjustZoomFovMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!(stack.m_41720_() instanceof GunItem)) {
                return;
            }
            GunData gun = GunData.from(stack);
            CompoundTag data = gun.data();
            if (stack.m_150930_((Item)ModItems.MINIGUN.get())) {
                double minRpm = -900.0;
                double maxRpm = 1200.0;
                int customRPM = data.m_128451_("CustomRPM");
                int targetCustomRPM = (int)Mth.m_14008_((double)((double)customRPM + 50.0 * message.scroll), (double)minRpm, (double)maxRpm);
                targetCustomRPM = targetCustomRPM == -50 ? -55 : Math.toIntExact(Math.round((double)targetCustomRPM / 50.0) * 50L);
                data.m_128405_("CustomRPM", targetCustomRPM);
                player.m_5661_((Component)Component.m_237113_((String)("RPM: " + FormatTool.format0D(customRPM + 1200))), true);
                if ((double)customRPM > minRpm && (double)customRPM < maxRpm) {
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.ADJUST_FOV.get(), 1.0f, 0.7f);
                }
            } else {
                double minZoom = gun.minZoom() - 1.25;
                double maxZoom = gun.maxZoom() - 1.25;
                double customZoom = data.m_128459_("CustomZoom");
                data.m_128347_("CustomZoom", Mth.m_14008_((double)(customZoom + 0.5 * message.scroll), (double)minZoom, (double)maxZoom));
                if (customZoom > minZoom && customZoom < maxZoom) {
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.ADJUST_FOV.get(), 1.0f, 0.7f);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

