/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.energy.ItemEnergyProvider;
import com.atsuishio.superbwarfare.client.renderer.gun.TaserItemRenderer;
import com.atsuishio.superbwarfare.client.tooltip.component.EnergyImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class TaserItem
extends GunItem {
    public static final int MAX_ENERGY = 6000;
    private final Supplier<Integer> energyCapacity = () -> 6000;

    public TaserItem() {
        super(new Item.Properties().m_41497_(Rarity.COMMON));
    }

    public boolean m_142522_(@NotNull ItemStack pStack) {
        if (!pStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return false;
        }
        int[] energy = new int[]{0};
        pStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> {
            energy[0] = e.getEnergyStored();
        });
        return energy[0] != 0;
    }

    public int m_142158_(@NotNull ItemStack pStack) {
        int[] energy = new int[]{0};
        pStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> {
            energy[0] = e.getEnergyStored();
        });
        return Math.round((float)energy[0] * 13.0f / 6000.0f);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack, this.energyCapacity.get());
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return 0xFFFF00;
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.TASER_RELOAD_EMPTY.get());
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return TaserItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<TaserItem> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.taser.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.taser.reload"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.taser.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.m_150109_().f_35974_) {
                if (!cell.m_150930_((Item)ModItems.CELL.get())) continue;
                assert (stack.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage stackStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                assert (cell.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(stackEnergyNeed, false));
                }
                cell.getCapability(ForgeCapabilities.ENERGY).ifPresent(cEnergy -> cEnergy.extractEnergy(stackEnergyNeed, false));
            }
        }
    }

    @Override
    public ResourceLocation getGunIcon(GunData data) {
        return Mod.loc("textures/gun_icon/taser_icon.png");
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new EnergyImageComponent(pStack));
    }

    @Override
    public void afterShoot(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        super.afterShoot(shooter, level, shootPosition, shootDirection, data, spread, zoom, uuid);
        ItemStack stack = data.stack;
        short perkLevel = data.perk.getLevel(ModPerks.VOLT_OVERLOAD);
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> energy.extractEnergy(400 + 100 * perkLevel, false));
    }

    @Override
    public boolean canShoot(GunData data, @Nullable Entity shooter) {
        ItemStack stack = data.stack;
        short perkLevel = data.perk.getLevel(ModPerks.VOLT_OVERLOAD);
        Boolean hasEnoughEnergy = stack.getCapability(ForgeCapabilities.ENERGY).map(storage -> storage.getEnergyStored() >= 400 + 100 * perkLevel).orElse(false);
        if (!hasEnoughEnergy.booleanValue()) {
            return false;
        }
        return super.canShoot(data, shooter);
    }
}

