/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.launcher;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.GunRendererBuilder;
import com.atsuishio.superbwarfare.client.model.item.M79ItemModel;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class M79Item
extends GunItem {
    public M79Item() {
        super(new Item.Properties().m_41486_().m_41497_(Rarity.RARE));
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.M_79_RELOAD_EMPTY.get());
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return GunRendererBuilder.simple(M79ItemModel::new, 0.0, 0.0, 0.59375, 1.0, true);
    }

    private PlayState idlePredicate(AnimationState<M79Item> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_79.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_79.reload"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_79.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 0, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
    }

    @Override
    public ResourceLocation getGunIcon(GunData data) {
        return Mod.loc("textures/gun_icon/m_79_icon.png");
    }

    @Override
    public boolean shootBullet(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        if (!super.shootBullet(shooter, level, shootPosition, shootDirection, data, spread, zoom, uuid)) {
            return false;
        }
        if (shooter != null) {
            ParticleTool.sendParticle(level, ParticleTypes.f_123796_, shooter.m_20185_() + 1.8 * shooter.m_20154_().f_82479_, shooter.m_20186_() + (double)shooter.m_20206_() - 0.1 + 1.8 * shooter.m_20154_().f_82480_, shooter.m_20189_() + 1.8 * shooter.m_20154_().f_82481_, 4, 0.1, 0.1, 0.1, 0.002, true);
        }
        return true;
    }
}

