/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.api.event.ReloadEvent;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.data.gun.ReloadType;
import com.atsuishio.superbwarfare.data.gun.subdata.Reload;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class GunEventHandler {
    private static void handleGunBolt(@NotNull GunData data) {
        ItemStack stack = data.stack();
        if (stack.m_204117_(ModTags.Items.NORMAL_GUN)) {
            data.bolt.actionTimer.reduce();
            Consumer<GunData> behavior = data.item.boltTimeBehaviors.get(data.bolt.actionTimer.get());
            if (behavior != null) {
                behavior.accept(data);
            }
            if (data.bolt.actionTimer.get() == 1) {
                data.bolt.needed.set(false);
            }
        }
    }

    public static void playGunBoltSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = data.stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_bolt"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 2.0f, 1.0f);
            double shooterHeight = shooter.m_146892_().m_82554_(Vec3.m_82528_((Vec3i)shooter.m_9236_().m_45547_(new ClipContext(shooter.m_146892_(), shooter.m_146892_().m_82549_(new Vec3(0.0, -1.0, 0.0).m_82490_(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter)).m_82425_()));
            Mod.queueServerWork((int)((double)data.bolt.actionTimer.get() / 2.0 + 1.5 * shooterHeight), () -> {
                if (data.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
                    Ammo ammoType = data.selectedAmmoConsumer().getPlayerAmmoType();
                    switch (ammoType) {
                        case SHOTGUN: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_SHOTGUN.get(), (float)Math.max(0.75 - 0.12 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        case SNIPER: 
                        case HEAVY: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_50CAL.get(), (float)Math.max(1.0 - 0.15 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        default: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                    }
                } else {
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                }
            });
        }
    }

    private static void finishReload(@Nullable Entity shooter, @NotNull GunData data) {
        if (data.item.isOpenBolt(data)) {
            if (!data.hasEnoughAmmoToShoot(shooter)) {
                GunEventHandler.finishGunEmptyReload(shooter, data);
            } else {
                GunEventHandler.finishGunNormalReload(shooter, data);
            }
        } else {
            GunEventHandler.finishGunEmptyReload(shooter, data);
        }
        data.reload.setTime(0);
        data.reload.setState(ReloadState.NOT_RELOADING);
        data.reload.reloadStarter.finish();
    }

    public static void init(@Nullable Entity shooter, @NotNull GunData data) {
        if (!data.initialized()) {
            Player player;
            data.initialize();
            if (shooter instanceof Player && (player = (Player)shooter).m_7500_()) {
                data.ammo.set(data.get(GunProp.MAGAZINE));
            }
        }
    }

    public static void tickPerk(@Nullable Entity shooter, @NotNull GunData data) {
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().tick(data, instance, shooter);
        }
    }

    public static void autoReload(@Nullable Entity shooter, GunData data) {
        if (data.get(GunProp.AUTO_RELOAD).booleanValue() && !data.hasEnoughAmmoToShoot(shooter)) {
            GunEventHandler.tryStartReload(shooter, data);
        }
    }

    public static void tryStartReload(@Nullable Entity shooter, GunData data) {
        if (data.useBackpackAmmo() || data.meleeOnly()) {
            return;
        }
        if (!(shooter != null && shooter.m_5833_() || data.charging() || data.reloading() || data.reload.time() != 0 || data.bolt.actionTimer.get() != 0)) {
            if (!data.hasBackupAmmo(shooter)) {
                return;
            }
            Set<ReloadType> reloadTypes = data.get(GunProp.RELOAD_TYPES);
            boolean canMagazineReload = reloadTypes.contains((Object)ReloadType.MAGAZINE) && !reloadTypes.contains((Object)ReloadType.CLIP);
            boolean canClipLoad = !data.hasEnoughAmmoToShoot(shooter) && reloadTypes.contains((Object)ReloadType.CLIP);
            boolean canSingleReload = reloadTypes.contains((Object)ReloadType.ITERATIVE);
            if (canMagazineReload || canClipLoad) {
                int magazine = data.get(GunProp.MAGAZINE);
                int extra = data.item.isOpenBolt(data) && data.item.hasBulletInBarrel(data) ? 1 : 0;
                int maxAmmo = magazine + extra;
                if (data.ammo.get() < maxAmmo) {
                    data.startReload();
                }
            } else if (canSingleReload && data.ammo.get() < data.get(GunProp.MAGAZINE)) {
                data.reload.singleReloadStarter.markStart();
            } else {
                return;
            }
            data.burstAmount.reset();
        }
    }

    public static void handleCooldown(@Nullable Entity shooter, @NotNull GunData data) {
        double extraCooldown = 0.0;
        if (shooter != null) {
            if (shooter.f_146809_) {
                extraCooldown = 0.15;
            } else if (shooter.m_20070_()) {
                extraCooldown = 0.04;
            } else if (shooter.m_6060_() || shooter.m_20077_()) {
                extraCooldown = -0.1;
            }
        }
        data.heat.set(Mth.m_14008_((double)(data.heat.get() - 0.25 - extraCooldown), (double)0.0, (double)100.0));
        if (data.heat.get() < 80.0 && data.overHeat.get()) {
            data.overHeat.set(false);
        }
    }

    public static void redrawExtraAmmo(@Nullable Entity shooter, @NotNull GunData data) {
        boolean hasBulletInBarrel = data.item.hasBulletInBarrel(data);
        int ammoCount = data.ammo.get();
        Integer magazine = data.get(GunProp.MAGAZINE);
        if (hasBulletInBarrel && ammoCount > magazine + 1 || !hasBulletInBarrel && ammoCount > magazine) {
            int count = ammoCount - magazine - (hasBulletInBarrel ? 1 : 0);
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                PlayerVariable.modify((Entity)player, capability -> {
                    if (data.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
                        Ammo ammoType = data.selectedAmmoConsumer().getPlayerAmmoType();
                        ammoType.add((PlayerVariable)capability, count);
                    }
                });
            }
            data.ammo.set(magazine + (hasBulletInBarrel ? 1 : 0));
        }
    }

    public static void gunTick(@Nullable Entity shooter, @NotNull GunData data, boolean inMainHand) {
        GunEventHandler.init(shooter, data);
        GunEventHandler.autoReload(shooter, data);
        GunEventHandler.tickPerk(shooter, data);
        GunEventHandler.handleCooldown(shooter, data);
        GunEventHandler.redrawExtraAmmo(shooter, data);
        if (inMainHand) {
            GunEventHandler.handleGunBolt(data);
            if (data.reload.reloadStarter.start()) {
                MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Pre(shooter, data));
                GunEventHandler.startReload(shooter, data);
            }
            data.reload.reduce();
            Consumer<GunData> behavior = data.item.reloadTimeBehaviors.get(data.reload.time());
            if (behavior != null) {
                behavior.accept(data);
            }
            if (data.reload.time() == 1) {
                GunEventHandler.finishReload(shooter, data);
            }
            GunEventHandler.handleGunSingleReload(shooter, data);
            GunEventHandler.handleSentinelCharge(shooter, data);
        }
        if (inMainHand && !data.reloading()) {
            if (data.currentAvailableShots(shooter) <= 5) {
                data.hideBulletChain.set(true);
            }
            if (!data.hasEnoughAmmoToShoot(shooter)) {
                data.holdOpen.set(true);
                data.isEmpty.set(true);
            }
        }
    }

    private static void startReload(@Nullable Entity shooter, @NotNull GunData data) {
        Reload reload = data.reload;
        if (data.item.isOpenBolt(data)) {
            if (!data.hasEnoughAmmoToShoot(shooter)) {
                reload.setTime(data.get(GunProp.EMPTY_RELOAD_TIME) + 1);
                reload.setState(ReloadState.EMPTY_RELOADING);
                GunEventHandler.playGunEmptyReloadSounds(shooter, data);
            } else {
                reload.setTime(data.get(GunProp.NORMAL_RELOAD_TIME) + 1);
                reload.setState(ReloadState.NORMAL_RELOADING);
                GunEventHandler.playGunNormalReloadSounds(shooter, data);
            }
        } else {
            reload.setTime(data.get(GunProp.EMPTY_RELOAD_TIME) + 2);
            reload.setState(ReloadState.EMPTY_RELOADING);
            GunEventHandler.playGunEmptyReloadSounds(shooter, data);
        }
    }

    public static void finishGunNormalReload(@Nullable Entity shooter, @NotNull GunData data) {
        GunItem gunItem = data.item();
        data.reloadAmmo(shooter, gunItem.hasBulletInBarrel(data));
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Post(shooter, data));
    }

    public static void finishGunEmptyReload(@Nullable Entity shooter, @NotNull GunData data) {
        data.reloadAmmo(shooter);
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Post(shooter, data));
    }

    public static void playGunEmptyReloadSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = data.stack;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_reload_empty"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    public static void playGunNormalReloadSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = data.stack;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_reload_normal"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    private static void handleGunSingleReload(@Nullable Entity shooter, @NotNull GunData data) {
        ItemStack stack = data.stack();
        Reload reload = data.reload;
        reload.prepareTimer.reduce();
        reload.prepareLoadTimer.reduce();
        reload.iterativeLoadTimer.reduce();
        reload.finishTimer.reduce();
        if (reload.singleReloadStarter.start()) {
            MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Pre(shooter, data));
            if (data.get(GunProp.PREPARE_LOAD_TIME) != 0 && (!data.hasEnoughAmmoToShoot(shooter) || stack.m_150930_((Item)ModItems.SECONDARY_CATACLYSM.get()))) {
                GunEventHandler.playGunPrepareLoadReloadSounds(shooter, data);
                int prepareLoadTime = data.get(GunProp.PREPARE_LOAD_TIME);
                reload.prepareLoadTimer.set(prepareLoadTime + 1);
            } else if (data.get(GunProp.PREPARE_EMPTY_TIME) != 0 && !data.hasEnoughAmmoToShoot(shooter)) {
                GunEventHandler.playGunEmptyPrepareSounds(shooter, data);
                int prepareEmptyTime = data.get(GunProp.PREPARE_EMPTY_TIME);
                reload.prepareTimer.set(prepareEmptyTime + 1);
            } else {
                GunEventHandler.playGunPrepareReloadSounds(shooter, data);
                int prepareTime = data.get(GunProp.PREPARE_TIME);
                reload.prepareTimer.set(prepareTime + 1);
            }
            data.forceStop.set(false);
            data.stopped.set(false);
            reload.setStage(1);
            reload.setState(ReloadState.NORMAL_RELOADING);
        }
        if (reload.prepareLoadTimer.get() == data.get(GunProp.PREPARE_AMMO_LOAD_TIME).intValue()) {
            GunEventHandler.iterativeLoad(shooter, data);
        }
        if (reload.prepareTimer.get() == 1 || reload.prepareLoadTimer.get() == 1) {
            if (!data.hasBackupAmmo(shooter) || data.ammo.get() >= data.get(GunProp.MAGAZINE)) {
                reload.stage3Starter.markStart();
            } else {
                reload.setStage(2);
            }
        }
        if (data.forceStop.get() && reload.stage() == 2 && reload.iterativeLoadTimer.get() > 0) {
            data.stopped.set(true);
        }
        if (!(reload.prepareTimer.get() != 0 && reload.iterativeLoadTimer.get() != 0 || reload.stage() != 2 || reload.iterativeLoadTimer.get() != 0 || data.stopped.get() || data.ammo.get() >= data.get(GunProp.MAGAZINE))) {
            GunEventHandler.playGunLoopReloadSounds(shooter, data);
            int iterativeTime = data.get(GunProp.ITERATIVE_TIME);
            reload.iterativeLoadTimer.set(iterativeTime);
            data.loadIndex.set(data.loadIndex.get() == 1 ? 0 : 1);
        }
        if (data.get(GunProp.ITERATIVE_AMMO_LOAD_TIME).intValue() == reload.iterativeLoadTimer.get()) {
            GunEventHandler.iterativeLoad(shooter, data);
        }
        if (reload.iterativeLoadTimer.get() == 1) {
            if (!data.hasBackupAmmo(shooter) || data.ammo.get() >= data.get(GunProp.MAGAZINE)) {
                reload.setStage(3);
            }
            if (data.stopped.get()) {
                reload.setStage(3);
                data.stopped.set(false);
                data.forceStop.set(false);
            }
        }
        if (reload.iterativeLoadTimer.get() == 1 && reload.stage() == 3 || reload.stage3Starter.shouldStart()) {
            reload.setStage(3);
            reload.stage3Starter.finish();
            int finishTime = data.get(GunProp.FINISH_TIME);
            reload.finishTimer.set(finishTime + 2);
            GunEventHandler.playGunEndReloadSounds(shooter, data);
        }
        if (stack.m_41720_() == ModItems.MARLIN.get() && reload.finishTimer.get() == 10) {
            data.isEmpty.set(false);
        }
        if (reload.finishTimer.get() == 1) {
            reload.setStage(0);
            if (data.get(GunProp.BOLT_ACTION_TIME) > 0) {
                data.bolt.needed.set(false);
            }
            reload.setState(ReloadState.NOT_RELOADING);
            reload.singleReloadStarter.finish();
            MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Post(shooter, data));
        }
    }

    public static void iterativeLoad(@Nullable Entity shooter, @NotNull GunData data) {
        int required = Math.min(data.get(GunProp.MAGAZINE) - data.ammo.get(), data.get(GunProp.ITERATIVE_LOAD_AMOUNT));
        int available = Math.min(required, data.countBackupAmmo(shooter));
        data.ammo.add(available);
        if (!InventoryTool.hasCreativeAmmoBox(shooter)) {
            data.consumeBackupAmmo(shooter, 1);
        }
    }

    public static void playGunPrepareReloadSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = data.stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_prepare"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    public static void playGunEmptyPrepareSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = data.stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_prepare_empty"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
            double shooterHeight = shooter.m_146892_().m_82554_(Vec3.m_82528_((Vec3i)shooter.m_9236_().m_45547_(new ClipContext(shooter.m_146892_(), shooter.m_146892_().m_82549_(new Vec3(0.0, -1.0, 0.0).m_82490_(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter)).m_82425_()));
            Mod.queueServerWork((int)((double)data.get(GunProp.PREPARE_EMPTY_TIME).intValue() / 2.0 + 3.0 + 1.5 * shooterHeight), () -> {
                if (data.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
                    Ammo ammoType = data.selectedAmmoConsumer().getPlayerAmmoType();
                    switch (ammoType) {
                        case SHOTGUN: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_SHOTGUN.get(), (float)Math.max(0.75 - 0.12 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        case SNIPER: 
                        case HEAVY: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_50CAL.get(), (float)Math.max(1.0 - 0.15 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        default: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                    }
                } else {
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                }
            });
        }
    }

    public static void playGunPrepareLoadReloadSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        ItemStack stack = data.stack;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_prepare_load"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
            double shooterHeight = shooter.m_146892_().m_82554_(Vec3.m_82528_((Vec3i)shooter.m_9236_().m_45547_(new ClipContext(shooter.m_146892_(), shooter.m_146892_().m_82549_(new Vec3(0.0, -1.0, 0.0).m_82490_(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter)).m_82425_()));
            Mod.queueServerWork((int)(8.0 + 1.5 * shooterHeight), () -> {
                if (data.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.PLAYER_AMMO) {
                    Ammo ammoType = data.selectedAmmoConsumer().getPlayerAmmoType();
                    switch (ammoType) {
                        case SHOTGUN: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_SHOTGUN.get(), (float)Math.max(0.75 - 0.12 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        case SNIPER: 
                        case HEAVY: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_50CAL.get(), (float)Math.max(1.0 - 0.15 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                        default: {
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                            break;
                        }
                    }
                } else {
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f);
                }
            });
        }
    }

    public static void playGunLoopReloadSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = data.stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_loop"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
        }
    }

    public static void playGunEndReloadSounds(@Nullable Entity shooter, @NotNull GunData data) {
        String origin;
        String name;
        SoundEvent sound1p;
        if (shooter != null && !shooter.m_9236_().f_46443_ && (sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc((name = (origin = data.stack.m_41720_().m_5524_()).substring(origin.lastIndexOf(".") + 1)) + "_end"))) != null && shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            SoundTool.playLocalSound(serverPlayer, sound1p, 10.0f, 1.0f);
            double shooterHeight = shooter.m_146892_().m_82554_(Vec3.m_82528_((Vec3i)shooter.m_9236_().m_45547_(new ClipContext(shooter.m_146892_(), shooter.m_146892_().m_82549_(new Vec3(0.0, -1.0, 0.0).m_82490_(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, shooter)).m_82425_()));
            if (data.stack.m_150930_((Item)ModItems.MARLIN.get())) {
                Mod.queueServerWork((int)(5.0 + 1.5 * shooterHeight), () -> SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.SHELL_CASING_NORMAL.get(), (float)Math.max(1.5 - 0.2 * shooterHeight, 0.0), 1.0f));
            }
        }
    }

    private static void handleSentinelCharge(Entity entity, GunData data) {
        if (data.charge.starter.start()) {
            data.charge.timer.set(127);
            SoundEvent sound1p = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(Mod.loc("sentinel_charge"));
            if (sound1p != null && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SoundTool.playLocalSound(serverPlayer, sound1p, 2.0f, 1.0f);
            }
        }
        data.charge.timer.reduce();
        if (data.charge.timer.get() == 17) {
            LazyOptional cap = entity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (cap.resolve().isEmpty()) {
                return;
            }
            IItemHandler itemHandler = (IItemHandler)cap.resolve().get();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                LazyOptional stackCap;
                ItemStack cell = itemHandler.getStackInSlot(i);
                if (!cell.m_150930_((Item)ModItems.CELL.get()) || !(stackCap = data.stack().getCapability(ForgeCapabilities.ENERGY)).isPresent()) continue;
                IEnergyStorage stackStorage = (IEnergyStorage)stackCap.resolve().get();
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                LazyOptional cellCap = cell.getCapability(ForgeCapabilities.ENERGY);
                if (!cellCap.isPresent()) continue;
                IEnergyStorage cellStorage = (IEnergyStorage)cellCap.resolve().get();
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stackStorage.receiveEnergy(stackEnergyNeed, false);
                }
                cellStorage.extractEnergy(stackEnergyNeed, false);
            }
        }
    }

    @SubscribeEvent
    public static void onMissingMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getAllMappings(Registries.f_256913_)) {
            if (!"superbwarfare".equals(mapping.getKey().m_135827_())) continue;
            String item = mapping.getKey().m_135815_();
            if (item.equals("abekiri")) {
                mapping.remap((Object)((Item)ModItems.HOMEMADE_SHOTGUN.get()));
            }
            if (item.equals("m2hb_blueprint")) {
                mapping.remap((Object)((Item)ModItems.M_2_HB_BLUEPRINT.get()));
            }
            if (!item.equals("rocket_70")) continue;
            mapping.remap((Object)((Item)ModItems.SMALL_ROCKET.get()));
        }
    }
}

