/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface WeaponVehicleEntity
extends ArmedVehicleEntity {
    default public boolean hasWeapon(int index) {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return false;
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        if (index < 0 || index >= vehicle.getMaxPassengers()) {
            return false;
        }
        List<VehicleWeapon> weapons = this.getAvailableWeapons(index);
        return !weapons.isEmpty();
    }

    default public void changeWeapon(int index, int value, boolean isScroll) {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        if (index < 0 || index >= vehicle.getMaxPassengers()) {
            return;
        }
        List<VehicleWeapon> weapons = this.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int count = weapons.size();
        int typeIndex = isScroll ? (value + this.getWeaponIndex(index) + count) % count : value;
        VehicleWeapon weapon = weapons.get(typeIndex);
        this.setWeaponIndex(index, typeIndex);
        SoundEvent sound = weapon.sound;
        if (sound != null) {
            vehicle.m_9236_().m_6269_(null, (Entity)vehicle, sound, vehicle.m_5720_(), 1.0f, 1.0f);
        }
    }

    default public VehicleWeapon[][] getAllWeapons() {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return new VehicleWeapon[0][];
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        if (vehicle.availableWeapons == null) {
            vehicle.availableWeapons = new VehicleWeapon[vehicle.getMaxPassengers()][];
            VehicleWeapon[][] weapons = this.initWeapons();
            for (int i = 0; i < weapons.length && i < vehicle.getMaxPassengers(); ++i) {
                vehicle.availableWeapons[i] = weapons[i];
            }
        }
        return vehicle.availableWeapons;
    }

    public VehicleWeapon[][] initWeapons();

    default public List<VehicleWeapon> getAvailableWeapons(int index) {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return List.of();
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        if (index < 0 || index >= vehicle.getMaxPassengers()) {
            return List.of();
        }
        if (vehicle.availableWeapons[index] != null) {
            return List.of(vehicle.availableWeapons[index]);
        }
        return List.of();
    }

    default public VehicleWeapon[][] initAvailableWeapons() {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return null;
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        if (vehicle.availableWeapons == null) {
            vehicle.availableWeapons = new VehicleWeapon[vehicle.getMaxPassengers()][];
        }
        return vehicle.availableWeapons;
    }

    default public VehicleWeapon getWeapon(int index) {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return null;
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        if (index < 0 || index >= vehicle.getMaxPassengers()) {
            return null;
        }
        List<VehicleWeapon> weapons = this.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return null;
        }
        int type = this.getWeaponIndex(index);
        if (type < 0 || type >= weapons.size()) {
            return null;
        }
        return weapons.get(type);
    }

    default public int getWeaponIndex(int index) {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return -1;
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        IntList selectedWeapons = (IntList)vehicle.m_20088_().m_135370_(VehicleEntity.SELECTED_WEAPON);
        if (selectedWeapons.size() <= index) {
            return -1;
        }
        return selectedWeapons.getInt(index);
    }

    default public void setWeaponIndex(int index, int type) {
        WeaponVehicleEntity weaponVehicleEntity = this;
        if (!(weaponVehicleEntity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)weaponVehicleEntity);
        int[] selectedWeapons = ((IntList)vehicle.m_20088_().m_135370_(VehicleEntity.SELECTED_WEAPON)).toIntArray();
        selectedWeapons[index] = type;
        vehicle.m_20088_().m_135381_(VehicleEntity.SELECTED_WEAPON, (Object)IntList.of((int[])selectedWeapons));
    }

    default public void playShootSound3p(LivingEntity living, int seat, int radius, int radius2, int radius3, Vec3 pos) {
        Level level;
        float pitch;
        List<VehicleWeapon> weapons = this.getAvailableWeapons(seat);
        VehicleWeapon weapon = weapons.get(this.getWeaponIndex(seat));
        float f = pitch = this.getWeaponHeat(living) <= 60 ? 1.0f : (float)(1.0 - 0.011 * (double)Math.abs(60 - this.getWeaponHeat(living)));
        if (living instanceof Player) {
            Player player = (Player)living;
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, seat, radius, radius2, radius3);
            }
        }
        if ((level = living.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (weapon.sound3p != null) {
                serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, weapon.sound3p, SoundSource.PLAYERS, (float)radius, pitch);
            }
            if (weapon.sound3pFar != null) {
                serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, weapon.sound3pFar, SoundSource.PLAYERS, (float)radius2, pitch);
            }
            if (weapon.sound3pVeryFar != null) {
                serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, weapon.sound3pVeryFar, SoundSource.PLAYERS, (float)radius3, pitch);
            }
        }
    }

    default public void playShootSound3p(Player player, int seat, int radius, int radius2, int radius3) {
        float pitch;
        List<VehicleWeapon> weapons = this.getAvailableWeapons(seat);
        VehicleWeapon weapon = weapons.get(this.getWeaponIndex(seat));
        float f = pitch = this.getWeaponHeat((LivingEntity)player) <= 60 ? 1.0f : (float)(1.0 - 0.011 * (double)Math.abs(60 - this.getWeaponHeat((LivingEntity)player)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (weapon.sound3p != null) {
                serverPlayer.m_5496_(weapon.sound3p, (float)radius, pitch);
            }
            if (weapon.sound3pFar != null) {
                serverPlayer.m_5496_(weapon.sound3pFar, (float)radius2, pitch);
            }
            if (weapon.sound3pVeryFar != null) {
                serverPlayer.m_5496_(weapon.sound3pVeryFar, (float)radius3, pitch);
            }
        }
    }
}

