/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimable;
import com.atsuishio.superbwarfare.entity.vehicle.base.DefenseEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WaveforceTowerEntity
extends VehicleEntity
implements GeoEntity,
OwnableEntity,
AutoAimable,
DefenseEntity {
    public static final EntityDataAccessor<Integer> COOL_DOWN = SynchedEntityData.m_135353_(WaveforceTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CHARGED_ENERGY = SynchedEntityData.m_135353_(WaveforceTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(WaveforceTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(WaveforceTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(WaveforceTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Float> WAVEFORCE_LENGTH = SynchedEntityData.m_135353_(WaveforceTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int changeTargetTimer = 60;
    public int chargeTime = 60;
    public int maxChargeEnergy = 250000;
    public float damage = 350.0f;

    public WaveforceTowerEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<WaveforceTowerEntity>)((EntityType)ModEntities.WAVEFORCE_TOWER.get()), world);
    }

    public WaveforceTowerEntity(EntityType<WaveforceTowerEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public WaveforceTowerEntity(LivingEntity owner, Level level) {
        super((EntityType)ModEntities.WAVEFORCE_TOWER.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COOL_DOWN, (Object)0);
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"none");
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHARGED_ENERGY, (Object)0);
        this.f_19804_.m_135372_(WAVEFORCE_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ChargedEnergy", ((Integer)this.f_19804_.m_135370_(CHARGED_ENERGY)).intValue());
        compound.m_128379_("Active", ((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue());
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        this.f_19804_.m_135381_(CHARGED_ENERGY, (Object)compound.m_128451_("ChargedEnergy"));
        this.f_19804_.m_135381_(ACTIVE, (Object)compound.m_128471_("Active"));
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (player.m_6047_()) {
            if (stack.m_204117_(ModTags.Items.CROWBAR) && (this.m_269323_() == null || player == this.m_269323_())) {
                ItemStack container = ContainerBlockItem.createInstance(this);
                if (!player.m_36356_(container)) {
                    player.m_36176_(container, false);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
            if (this.m_21805_() == null) {
                this.setOwnerUUID(player.m_20148_());
            }
            if (this.m_269323_() == player) {
                this.f_19804_.m_135381_(ACTIVE, (Object)((Boolean)this.f_19804_.m_135370_(ACTIVE) == false ? 1 : 0));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11686_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, Math.min((double)super.m_20184_().f_82480_, (double)0.0), 0.0);
    }

    @Override
    public void m_6075_() {
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        super.m_6075_();
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            this.f_19804_.m_135381_(COOL_DOWN, (Object)((Integer)this.f_19804_.m_135370_(COOL_DOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(CHARGED_ENERGY) < this.maxChargeEnergy) {
            float chargeSpeed = Mth.m_14045_((int)(this.maxChargeEnergy / this.chargeTime), (int)0, (int)this.getEnergy());
            this.f_19804_.m_135381_(CHARGED_ENERGY, (Object)((int)Mth.m_14036_((float)((float)((Integer)this.f_19804_.m_135370_(CHARGED_ENERGY)).intValue() + chargeSpeed), (float)0.0f, (float)this.maxChargeEnergy)));
            this.consumeEnergy((int)Mth.m_14036_((float)chargeSpeed, (float)0.0f, (float)(this.maxChargeEnergy - (Integer)this.f_19804_.m_135370_(CHARGED_ENERGY))));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.autoAim();
    }

    @Override
    public void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.m_14175_((double)(this.serverYRot - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.serverXRot - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    @Override
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    public void autoAim() {
        Entity target;
        Entity naerestEntity;
        if (!((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue()) {
            return;
        }
        if (((String)this.f_19804_.m_135370_(TARGET_UUID)).equals("none") && this.f_19797_ % 10 == 0 && (naerestEntity = this.seekNearLivingEntity(this, this.getShootPos(1.0f), -50.0, 50.0, 2.0, 128.0, 0.01)) != null) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)naerestEntity.m_20149_());
        }
        if ((target = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID))) != null && SeekTool.smokeFilter(target)) {
            boolean canShoot;
            LivingEntity living;
            Player player1;
            if (target instanceof Player && ((player1 = (Player)target).m_5833_() || player1.m_7500_())) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (VehicleEntity.getSubmergedHeight(target) >= (double)target.m_20206_()) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target.m_20270_((Entity)this) > 144.0f) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target instanceof LivingEntity && (living = (LivingEntity)target).m_21223_() <= 0.0f) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target == this || target instanceof TargetEntity) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            if (target instanceof Projectile && (VectorTool.calculateAngle(target.m_20184_().m_82541_(), target.m_20182_().m_82505_(this.m_20182_()).m_82541_()) > 60.0 || target.m_20096_() || target.m_20184_().m_82556_() < 0.001)) {
                this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                return;
            }
            Vec3 targetVec = this.getShootPos(1.0f).m_82505_(target.m_146892_()).m_82541_();
            if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) == 0) {
                this.turretAutoAimFormVector(targetVec);
            }
            boolean bl = canShoot = (Integer)this.f_19804_.m_135370_(CHARGED_ENERGY) >= this.maxChargeEnergy;
            if (canShoot && VectorTool.calculateAngle(this.getBarrelVec(1.0f), targetVec) < 1.0) {
                ++this.changeTargetTimer;
            }
            if (canShoot && VectorTool.calculateAngle(this.getBarrelVec(1.0f), targetVec) < 1.0 && this.checkNoClip(this, target, this.getShootPos(1.0f))) {
                if (this.m_9236_() instanceof ServerLevel) {
                    this.m_9236_().m_245803_((Entity)this, this.m_20097_(), (SoundEvent)ModSounds.WAVEFORCE_TOWER_FIRE.get(), SoundSource.PLAYERS, 6.0f, this.f_19796_.m_188501_() * 0.1f + 1.0f);
                }
                Predicate<Entity> filter = entity -> entity != this && !SeekTool.friendlyToPlayer((Entity)this.m_269323_(), entity);
                List<TraceTool.RayTraceResultEntity> hitList = TraceTool.getEntitiesAlongVector(this.m_9236_(), this.getShootPos(1.0f), this.getBarrelVec(1.0f), this.getShootPos(1.0f).m_82554_(target.m_146892_()) + 0.5, filter);
                for (TraceTool.RayTraceResultEntity hit : hitList) {
                    Entity entity2 = hit.entity;
                    Vec3 hitPos = hit.hitVec;
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123810_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 12, 0.0, 0.0, 0.0, 0.05, true);
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123756_, hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, 4, 0.0, 0.0, 0.0, 0.15, true);
                    }
                    DamageHandler.doDamage(entity2, ModDamageTypes.causeLaserStaticDamage(this.m_9236_().m_9598_(), this, (Entity)this.m_269323_()), this.damage * Math.min((float)((float)((Integer)this.f_19804_.m_135370_(CHARGED_ENERGY)).intValue() / (float)this.maxChargeEnergy), (float)1.0f));
                    target.f_19802_ = 0;
                    if (!(Math.random() < 0.5) || !(target instanceof LivingEntity)) continue;
                    LivingEntity living2 = (LivingEntity)target;
                    living2.m_20254_(5);
                }
                this.f_19804_.m_135381_(WAVEFORCE_LENGTH, (Object)Float.valueOf((float)this.getLaserPos(1.0f).m_82554_(target.m_146892_())));
                if (!target.m_6084_()) {
                    this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
                }
                this.f_19804_.m_135381_(CHARGED_ENERGY, (Object)0);
                this.f_19804_.m_135381_(COOL_DOWN, (Object)25);
            }
        } else {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
        }
        if (this.changeTargetTimer > 60) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)"none");
            this.changeTargetTimer = 0;
        }
    }

    @Override
    public float turretYSpeed() {
        return 8.0f;
    }

    @Override
    public float turretXSpeed() {
        return 12.0f;
    }

    @Override
    public float turretMinPitch() {
        return -45.0f;
    }

    @Override
    public float turretMaxPitch() {
        return 40.0f;
    }

    @Override
    public boolean basicEnemyFilter(Entity pEntity) {
        if (pEntity instanceof Projectile) {
            return false;
        }
        if (this.m_269323_() == null) {
            return false;
        }
        if (pEntity.m_5647_() == null) {
            return false;
        }
        return !pEntity.m_7307_((Entity)this.m_269323_()) || pEntity.m_5647_() != null && pEntity.m_5647_().m_5758_().equals("TDM");
    }

    @Override
    public boolean basicEnemyProjectileFilter(Projectile projectile) {
        if (this.m_269323_() == null) {
            return false;
        }
        if (projectile.m_19749_() != null && projectile.m_19749_() == this.m_269323_()) {
            return false;
        }
        return projectile.m_19749_() != null && !projectile.m_19749_().m_7307_((Entity)this.m_269323_()) || projectile.m_19749_() != null && projectile.m_19749_().m_5647_() != null && projectile.m_19749_().m_5647_().m_5758_().equals("TDM") || projectile.m_19749_() == null;
    }

    @Override
    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.0f, -0.05843125f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.41615626f, -0.02555f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x));
        return transformT;
    }

    @Override
    public Vec3 getBarrelVec(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getShootPos(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.5243625f, 0.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z);
    }

    public Vec3 getLaserPos(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.5243625f, 3.0287561f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z);
    }

    private PlayState firePredicate(AnimationState<WaveforceTowerEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(COOL_DOWN) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.waveforce_tower.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.waveforce_tower.idle"));
    }

    private PlayState barrelLightPredicate(AnimationState<WaveforceTowerEntity> event) {
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.waveforce_tower.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "barrelLight", 0, this::barrelLightPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "fire", 0, this::firePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/waveforce_tower_icon.png");
    }

    @Override
    public boolean hasEnergyStorage() {
        return true;
    }
}

