/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.VehicleAssemblingTableBlock;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.menu.VehicleAssemblingMenu;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VehicleAssemblingTableVehicleEntity
extends MobileVehicleEntity
implements GeoEntity,
HasCustomInventoryScreen,
MenuProvider {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float yRotSync;
    public float deltaXo;
    public float deltaYo;
    public float deltaX;
    public float deltaY;
    public int jumpCooldown;

    public VehicleAssemblingTableVehicleEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public VehicleAssemblingTableVehicleEntity(PlayMessages.SpawnEntity packet, Level level) {
        this((EntityType)ModEntities.VEHICLE_ASSEMBLING_TABLE.get(), level);
    }

    public VehicleAssemblingTableVehicleEntity(Level world) {
        this((EntityType)ModEntities.VEHICLE_ASSEMBLING_TABLE.get(), world);
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 2.0), this.f_19796_.m_188501_() * 0.1f + 1.0f);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        if (player.m_21205_().m_204117_(ModTags.Items.CROWBAR) && !player.m_6047_()) {
            if (!this.m_9236_().f_46443_ && this.m_20197_().isEmpty()) {
                BlockPos blockPos;
                Direction facing = this.m_6350_();
                Vec3 currentPos = this.m_20182_();
                Vec3 targetPos = switch (facing) {
                    case Direction.WEST -> currentPos.m_82520_(-0.5, 0.0, -0.5);
                    case Direction.EAST -> currentPos.m_82520_(0.5, 0.0, 0.5);
                    case Direction.NORTH -> currentPos.m_82520_(0.5, 0.0, -0.5);
                    case Direction.SOUTH -> currentPos.m_82520_(-0.5, 0.0, 0.5);
                    default -> currentPos;
                };
                BlockPos targetBlockPos = BlockPos.m_274446_((Position)targetPos);
                boolean canPlace = true;
                for (BlockPart part : BlockPart.values()) {
                    blockPos = part.relative(targetBlockPos, facing);
                    BlockState blockState = this.m_9236_().m_8055_(blockPos);
                    if (blockState.m_247087_()) continue;
                    canPlace = false;
                    break;
                }
                if (canPlace) {
                    for (BlockPart part : BlockPart.values()) {
                        blockPos = part.relative(targetBlockPos, facing);
                        BlockState state = (BlockState)((BlockState)((Block)ModBlocks.VEHICLE_ASSEMBLING_TABLE.get()).m_49966_().m_61124_((Property)VehicleAssemblingTableBlock.FACING, (Comparable)facing)).m_61124_(VehicleAssemblingTableBlock.BLOCK_PART, (Comparable)((Object)part));
                        this.m_9236_().m_7731_(blockPos, state, 3);
                    }
                    this.m_146870_();
                    return InteractionResult.SUCCESS;
                }
                player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.vehicle_assembling_table.warn").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        }
        return super.m_6096_(player, hand);
    }

    @Override
    public void m_6075_() {
        this.deltaXo = this.deltaX;
        this.deltaYo = this.deltaY;
        super.m_6075_();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        this.deltaX = ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_Y)).floatValue();
        if (this.leftInputDown && this.rightInputDown) {
            this.deltaX = 0.0f;
        } else if (this.leftInputDown) {
            this.deltaX = -1.0f;
        } else if (this.rightInputDown) {
            this.deltaX = 1.0f;
        }
        float f = this.m_20096_() ? 0.85f : 0.9f;
        this.m_20256_(this.m_20184_().m_82542_((double)f, (double)f, (double)f));
        if (this.m_20069_() && this.f_19797_ % 4 == 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            if (this.lastTickSpeed > 0.4) {
                this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, this.m_146895_() == null ? this : this.m_146895_()), (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            }
        }
        this.terrainCompact(1.95f, 1.95f);
        this.m_6210_();
    }

    @Override
    public void travel() {
        Entity passenger = this.m_146895_();
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.95f));
        if (passenger == null || this.m_20069_()) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.m_20256_(this.m_20184_().m_82542_(0.96, 1.0, 0.96));
        } else if (passenger instanceof Player) {
            if (this.forwardInputDown) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.1f), (float)1.0f)));
            }
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * 0.8f));
            if (this.backInputDown) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 0.1f : 0.01f)), (float)(this.m_20096_() ? -0.2f : 0.2f))));
                if (this.rightInputDown) {
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.4f));
                } else if (this.leftInputDown) {
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.4f));
                }
            } else if (this.rightInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.4f));
            } else if (this.leftInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.4f));
            }
            if (this.downInputDown) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
            }
            if (this.upInputDown && this.m_20096_() && this.jumpCooldown == 0) {
                this.jumpCooldown = 40;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.WHEEL_CHAIR_JUMP.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
                }
                Vec3 movement = this.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(0.7);
                this.m_20256_(this.m_20184_().m_82520_(movement.f_82479_, 1.0, movement.f_82481_));
            }
            float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.m_14177_((float)(passenger.m_6080_() - this.m_146908_())));
            float diffX = Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.m_14177_((float)(passenger.m_146909_() - this.m_146909_())));
            float addX = Mth.m_14036_((float)(Math.min((float)((float)Math.max((double)(this.m_20184_().m_82553_() - 0.1), (double)0.01)), (float)0.9f) * diffX), (float)-4.0f, (float)4.0f);
            float addZ = ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - (this.m_20096_() ? 0.0f : 0.01f) * diffY * (float)this.m_20184_().m_82553_();
            this.yRotSync = (float)(-Mth.m_14008_((double)(50.0 * this.m_20184_().m_82553_()), (double)2.0, (double)4.0) * (double)((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue());
            this.m_146922_(this.m_146908_() + this.yRotSync);
            this.m_146926_(Mth.m_14036_((float)(this.m_146909_() + addX), (float)(this.m_20096_() ? -12.0f : -120.0f), (float)(this.m_20096_() ? 3.0f : 120.0f)));
            this.setZRot(this.getRoll() - 0.2f * addZ);
        }
        double powerValue = 0.05 * (double)((Float)this.f_19804_.m_135370_(POWER)).floatValue();
        this.m_20256_(this.m_20184_().m_82549_(this.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82542_(powerValue, powerValue, powerValue)));
    }

    @Override
    public boolean engineRunning() {
        return this.m_146895_() != null && Math.abs((double)this.m_20184_().m_82553_()) > 0.0;
    }

    @Override
    public float getEngineSoundVolume() {
        return (float)this.m_20184_().m_82553_();
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.m_14177_((float)(entity.m_146909_() - this.m_146909_()));
        float f1 = Mth.m_14036_((float)f, (float)-85.0f, (float)60.0f);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
        entity.m_5618_(this.m_146908_());
        float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f3 = Mth.m_14036_((float)f2, (float)-45.0f, (float)45.0f);
        entity.f_19859_ += f3 - f2;
        entity.m_146922_(entity.m_146908_() + f3 - f2);
        entity.m_5618_(this.m_146908_());
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_146922_(passenger.m_146908_() + this.m_146908_() - this.f_19859_);
        passenger.m_5616_(passenger.m_6080_() + this.m_146908_() - this.f_19859_);
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = -0.4f;
        float y = -0.6f + (float)passenger.m_6049_();
        float z = 0.2f;
        int i = this.getSeatIndex(passenger);
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.m_146895_()) {
            passenger.m_146926_(passenger.m_146909_() + (this.m_146909_() - this.f_19860_));
        }
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        float i = this.m_146909_() / 90.0f;
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f + this.yRotSync * Mth.m_14154_((float)i));
        entity.m_5616_(entity.m_146908_());
        entity.m_5618_(this.m_146908_());
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + 0.5), (double)(this.m_20186_() + 0.5)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.m_9236_() instanceof ServerLevel) {
            ItemEntity item = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()));
            item.m_32010_(50);
            this.m_9236_().m_7967_((Entity)item);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/vehicle_assembling_table_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return 0.3;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.f_252529_.m_252977_(-this.m_5686_(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.getRoll(tickDelta)));
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/civilian.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (ClientEventHandler.isFreeCam(player) && this.getSeatIndex((Entity)player) == 0 && (double)Mth.m_14154_((float)((float)(ClientMouseHandler.freeCameraYaw * ClientMouseHandler.freeCameraPitch))) > 0.01) {
            return new Vec2((float)((double)(this.getYaw(partialTicks) - 0.5f * Mth.m_14179_((float)partialTicks, (float)this.deltaYo, (float)this.deltaY)) - ClientMouseHandler.freeCameraYaw), (float)((double)(this.getPitch(partialTicks) - 0.5f * Mth.m_14179_((float)partialTicks, (float)this.deltaXo, (float)this.deltaX)) + ClientMouseHandler.freeCameraPitch));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @NotNull
    public List<ItemStack> getRetrieveItems() {
        return List.of(new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()));
    }

    @Override
    @Nullable
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int seatIndex) {
        return new ThirdPersonCameraPosition(1.5 * ClientMouseHandler.custom3pDistanceLerp, 0.0, 0.0);
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    public boolean hasEnergyStorage() {
        return false;
    }

    public void m_213583_(@NotNull Player player) {
        player.m_5893_((MenuProvider)this);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new VehicleAssemblingMenu(i, inventory, true);
    }
}

