/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.MineEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Tm62Entity
extends Entity
implements GeoEntity,
OwnableEntity,
MineEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.m_135353_(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> FUSE = SynchedEntityData.m_135353_(Tm62Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().multiply(0.02f, ModDamageTypes.CUSTOM_EXPLOSION).multiply(0.02f, ModDamageTypes.MINE).multiply(0.02f, ModDamageTypes.PROJECTILE_EXPLOSION).multiply(0.02f, (ResourceKey<DamageType>)DamageTypes.f_268565_);

    public Tm62Entity(EntityType<Tm62Entity> type, Level world) {
        super(type, world);
    }

    public Tm62Entity(LivingEntity owner, Level level, boolean fuse) {
        super((EntityType)ModEntities.TM_62.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
        this.f_19804_.m_135381_(FUSE, (Object)fuse);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(LAST_ATTACKER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(FUSE, (Object)false);
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(100.0f));
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        if (source.m_7639_() != null) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)source.m_7639_().m_20149_());
        }
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.m_269323_();
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128359_("LastAttacker", (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        compound.m_128379_("Fuse", ((Boolean)this.f_19804_.m_135370_(FUSE)).booleanValue());
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("LastAttacker")) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)compound.m_128461_("LastAttacker"));
        }
        if (compound.m_128441_("Fuse")) {
            this.f_19804_.m_135381_(FUSE, (Object)compound.m_128471_("Fuse"));
        }
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.isOwnedBy((LivingEntity)player) && player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            if (!player.m_150110_().f_35937_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.TM_62.get()));
            }
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.f_19797_ >= 20 && this.m_20096_() && !((Boolean)this.f_19804_.m_135370_(FUSE)).booleanValue()) {
            this.touchEntity();
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        if (!this.m_9236_().m_45772_(this.m_20191_())) {
            this.m_20314_(this.m_20185_(), (this.m_20191_().f_82289_ + this.m_20191_().f_82292_) / 2.0, this.m_20189_());
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float f = 0.98f;
        if (this.m_20096_()) {
            BlockPos pos = this.m_20099_();
            f = this.m_9236_().m_8055_(pos).getFriction((LevelReader)this.m_9236_(), pos, (Entity)this) * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)f, 0.98, (double)f));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, -0.9, 1.0));
        }
        if (((Boolean)this.f_19804_.m_135370_(FUSE)).booleanValue() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123762_, this.f_19854_, this.f_19855_, this.f_19856_, 1, 0.0, 0.0, 0.0, 0.01, true);
        }
        if (((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f || ((Boolean)this.f_19804_.m_135370_(FUSE)).booleanValue() && this.f_19797_ >= 100) {
            this.triggerExplode();
        }
        this.m_6210_();
    }

    public void touchEntity() {
        if (this.m_9236_() instanceof ServerLevel) {
            AABB frontBox = this.m_20191_().m_82400_(0.2);
            boolean trigger = false;
            List entities = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(Entity.class), frontBox, entity -> entity != this && !(entity instanceof HangingEntity) && (entity.m_20191_().m_82309_() > 1.5 || entity.m_20191_().m_82309_() > 0.9 && entity.m_20184_().m_7098_() < -0.35)).stream().toList();
            for (Entity entity2 : entities) {
                if (entity2 == null) continue;
                trigger = true;
                break;
            }
            if (trigger) {
                this.triggerExplode();
                if (this.m_9236_() instanceof ServerLevel) {
                    AABB aabb = new AABB(this.m_20182_(), this.m_20182_()).m_82400_(2.0);
                    BlockPos.m_121921_((AABB)aabb).forEach(blockPos -> {
                        float hard = this.m_9236_().m_8055_(blockPos).m_60734_().m_155943_();
                        if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && hard != -1.0f) {
                            this.m_9236_().m_46961_(blockPos, true);
                        }
                    });
                }
            }
        }
    }

    private void triggerExplode() {
        new CustomExplosion.Builder(this).attacker((Entity)this.m_269323_()).damage(450.0f).radius(13.0f).withParticleType(ParticleTool.ParticleType.HUGE).explode();
        this.m_146870_();
    }

    public boolean m_6094_() {
        return super.m_6094_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(vec3);
    }
}

