/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public class TargetEntity
extends LivingEntity
implements GeoEntity {
    public static final EntityDataAccessor<Integer> DOWN_TIME = SynchedEntityData.m_135353_(TargetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().immuneTo((ResourceKey<DamageType>)DamageTypes.f_268450_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268526_).immuneTo((ResourceKey<DamageType>)DamageTypes.f_268515_);

    public TargetEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<TargetEntity>)((EntityType)ModEntities.TARGET.get()), world);
    }

    public TargetEntity(EntityType<TargetEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DOWN_TIME, (Object)0);
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pSize) {
        return 1.57f;
    }

    @NotNull
    public MobType m_6336_() {
        return super.m_6336_();
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack) {
    }

    public boolean m_142535_(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_286979_)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return super.m_6469_(source, amount);
        }
        if ((amount = DAMAGE_MODIFIER.compute(source, amount)) <= 0.0f || (Integer)this.f_19804_.m_135370_(DOWN_TIME) > 0) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        return super.m_6469_(source, amount);
    }

    @SubscribeEvent
    public static void onTargetDown(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (event.getSource().m_276093_(DamageTypes.f_286979_)) {
            return;
        }
        Entity sourceEntity = event.getSource().m_7639_();
        if (entity == null) {
            return;
        }
        if (entity instanceof TargetEntity) {
            TargetEntity targetEntity = (TargetEntity)entity;
            event.setCanceled(true);
            targetEntity.m_21153_(targetEntity.m_21233_());
            if (sourceEntity == null) {
                return;
            }
            if (sourceEntity instanceof Player) {
                Player player = (Player)sourceEntity;
                player.m_5661_((Component)Component.m_237110_((String)"tips.superbwarfare.target.down", (Object[])new Object[]{FormatTool.format1D(entity.m_20182_().m_82554_(sourceEntity.m_20182_()), "m")}), true);
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.TARGET_DOWN.get(), 1.0f, 1.0f);
                targetEntity.f_19804_.m_135381_(DOWN_TIME, (Object)40);
            }
        }
    }

    public boolean m_6087_() {
        return (Integer)this.f_19804_.m_135370_(DOWN_TIME) == 0;
    }

    public void m_6667_(@NotNull DamageSource source) {
        super.m_6667_(source);
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!player.m_21205_().m_41619_() && !player.m_21205_().m_204117_(ModTags.Items.CROWBAR)) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            if (!player.m_150110_().f_35937_) {
                player.m_36356_(new ItemStack((ItemLike)ModItems.TARGET_DEPLOYER.get()));
            }
        } else {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(player.m_20185_(), this.m_20186_(), player.m_20189_()));
            this.m_146926_(0.0f);
            this.f_19860_ = this.m_146909_();
            this.f_19804_.m_135381_(DOWN_TIME, (Object)0);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_8119_() {
        super.m_8119_();
        if ((Integer)this.f_19804_.m_135370_(DOWN_TIME) > 0) {
            this.f_19804_.m_135381_(DOWN_TIME, (Object)((Integer)this.f_19804_.m_135370_(DOWN_TIME) - 1));
        }
    }

    @NotNull
    public Vec3 m_20184_() {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean m_6094_() {
        return false;
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected void m_7324_(@NotNull Entity entityIn) {
    }

    protected void m_6138_() {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        this.m_20242_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 100) {
            this.m_19983_(new ItemStack((ItemLike)ModItems.TARGET_DEPLOYER.get()));
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private PlayState movementPredicate(AnimationState<TargetEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(DOWN_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.target.down"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.target.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.TARGET_DEPLOYER.get());
    }
}

