/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class C4Entity
extends Entity
implements GeoEntity,
OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.m_135353_(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.m_135353_(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> IS_CONTROLLABLE = SynchedEntityData.m_135353_(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BOMB_TICK = SynchedEntityData.m_135353_(C4Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int DEFAULT_DEFUSE_PROGRESS = 100;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected boolean inGround;
    protected boolean onEntity;
    @Nullable
    private BlockState lastState;

    public C4Entity(EntityType<C4Entity> type, Level level) {
        super(type, level);
    }

    public C4Entity(LivingEntity owner, Level level) {
        this(owner, level, false);
    }

    public C4Entity(LivingEntity owner, Level level, boolean isControllable) {
        super((EntityType)ModEntities.C_4.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.m_20148_());
        }
        this.f_19804_.m_135381_(IS_CONTROLLABLE, (Object)isControllable);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(LAST_ATTACKER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(TARGET_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(IS_CONTROLLABLE, (Object)false);
        this.f_19804_.m_135372_(BOMB_TICK, (Object)0);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128359_("Target", (String)this.f_19804_.m_135370_(TARGET_UUID));
        compound.m_128359_("LastAttacker", (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        compound.m_128379_("IsControllable", ((Boolean)this.f_19804_.m_135370_(IS_CONTROLLABLE)).booleanValue());
        compound.m_128405_("BombTick", ((Integer)this.f_19804_.m_135370_(BOMB_TICK)).intValue());
        if (this.lastState != null) {
            compound.m_128365_("InBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.lastState));
        }
        if (this.m_21805_() != null) {
            compound.m_128362_("Owner", this.m_21805_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        if (compound.m_128441_("LastAttacker")) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)compound.m_128461_("LastAttacker"));
        }
        if (compound.m_128441_("Target")) {
            this.f_19804_.m_135381_(TARGET_UUID, (Object)compound.m_128461_("Target"));
        }
        if (compound.m_128425_("InBlockState", 10)) {
            this.lastState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("InBlockState"));
        }
        if (compound.m_128441_("IsControllable")) {
            this.f_19804_.m_135381_(IS_CONTROLLABLE, (Object)compound.m_128471_("IsControllable"));
        }
        if (compound.m_128441_("BombTick")) {
            this.f_19804_.m_135381_(BOMB_TICK, (Object)compound.m_128451_("BombTick"));
        }
        if (compound.m_128403_("Owner")) {
            uuid = compound.m_128342_("Owner");
        } else {
            String s = compound.m_128461_("Owner");
            try {
                uuid = this.m_20194_() == null ? UUID.fromString(s) : OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            catch (Exception exception) {
                Mod.LOGGER.error("Couldn't load owner UUID of {}: {}", (Object)this, (Object)exception);
                uuid = null;
            }
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_269323_() == player && player.m_6144_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
            if (!player.m_150110_().f_35937_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getItemStack());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        super.m_8119_();
        if (!((Boolean)this.f_19804_.m_135370_(IS_CONTROLLABLE)).booleanValue()) {
            int countdown;
            int bombTick = (Integer)this.f_19804_.m_135370_(BOMB_TICK);
            if (bombTick >= (Integer)ExplosionConfig.C4_EXPLOSION_COUNTDOWN.get()) {
                this.explode();
            }
            if ((countdown = ((Integer)ExplosionConfig.C4_EXPLOSION_COUNTDOWN.get()).intValue()) - bombTick > 39 && bombTick % (20 * (countdown - bombTick) / countdown + 1) == 0) {
                this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.C4_BEEP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (bombTick == countdown - 39) {
                this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.C4_FINAL.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
            }
            this.f_19804_.m_135381_(BOMB_TICK, (Object)(bombTick + 1));
        }
        Vec3 motion = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f && !this.inGround) {
            double d0 = motion.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        BlockPos blockpos = this.m_20183_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!blockstate.m_60795_() && !(voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.inGround) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            }
        } else if (!this.onEntity) {
            Vec3 position = this.m_20182_();
            Vec3 nextPosition = position.m_82549_(motion);
            BlockHitResult hitresult = this.m_9236_().m_45547_(new ClipContext(position, nextPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                nextPosition = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.findHitEntity(position, nextPosition);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS) {
                    this.onHit((HitResult)hitresult);
                    this.f_19812_ = true;
                    break;
                }
                if (entityhitresult == null) break;
                hitresult = null;
            }
            if (this.m_213877_()) {
                return;
            }
            motion = this.m_20184_();
            double pX = motion.f_82479_;
            double pY = motion.f_82480_;
            double pZ = motion.f_82481_;
            double nX = this.m_20185_() + pX;
            double nY = this.m_20186_() + pY;
            double nZ = this.m_20189_() + pZ;
            this.updateRotation();
            float f = 0.99f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, nX - pX * 0.25, nY - pY * 0.25, nZ - pZ * 0.25, pX, pY, pZ);
                }
                f = this.getWaterInertia();
            }
            this.m_20256_(motion.m_82490_((double)f));
            if (!this.m_20068_()) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(nX, nY, nZ);
            this.m_20101_();
        } else {
            Entity target = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID));
            if (target != null) {
                this.m_6034_(target.m_20185_(), target.m_20186_() + (double)target.m_20206_(), target.m_20189_());
            } else {
                this.onEntity = false;
            }
        }
        this.m_6210_();
    }

    private boolean shouldFall() {
        return this.inGround && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vec3 = this.m_20184_();
        this.m_20256_(vec3.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        super.m_6478_(pType, pPos);
        if (pType != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void look(Vec3 pTarget) {
        double d0 = pTarget.f_82479_;
        double d1 = pTarget.f_82480_;
        double d2 = pTarget.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.m_146926_(Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875)))));
        this.m_5616_(this.m_146908_());
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    protected void updateRotation() {
        if (this.m_20184_().m_82553_() > 0.05 && !this.inGround && !this.onEntity) {
            Vec3 vec3 = this.m_20184_();
            double d0 = vec3.m_165924_();
            this.m_146926_(C4Entity.lerpRotation(this.f_19860_, (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875)));
            this.m_146922_(C4Entity.lerpRotation(this.f_19859_, (float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)));
        }
    }

    protected static float lerpRotation(float pCurrentRotation, float pTargetRotation) {
        while (pTargetRotation - pCurrentRotation < -180.0f) {
            pCurrentRotation -= 360.0f;
        }
        while (pTargetRotation - pCurrentRotation >= 180.0f) {
            pCurrentRotation += 360.0f;
        }
        return Mth.m_14179_((float)0.2f, (float)pCurrentRotation, (float)pTargetRotation);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), this::canHitEntity);
    }

    protected boolean canHitEntity(Entity pTarget) {
        if (!pTarget.m_271807_()) {
            return false;
        }
        LivingEntity entity = this.m_269323_();
        return entity == null || entity == pTarget && this.f_19797_ > 2 || !entity.m_20365_(pTarget);
    }

    protected void onHit(HitResult pResult) {
        switch (pResult.m_6662_()) {
            case BLOCK: {
                this.onHitBlock((BlockHitResult)pResult);
                break;
            }
            case ENTITY: {
                this.onHitEntity((EntityHitResult)pResult);
                break;
            }
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        if (this.f_19797_ < 2 || entity == this.m_20202_() || entity instanceof C4Entity) {
            return;
        }
        this.f_19804_.m_135381_(TARGET_UUID, (Object)entity.m_20149_());
        this.onEntity = true;
        this.m_20256_(this.m_20184_().m_82542_(0.0, 0.0, 0.0));
        this.m_146926_(-90.0f);
        this.f_19860_ = this.m_146909_();
    }

    protected void onHitBlock(BlockHitResult pResult) {
        this.lastState = this.m_9236_().m_8055_(pResult.m_82425_());
        Vec3 vec3 = pResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.look(Vec3.m_82528_((Vec3i)pResult.m_82434_().m_122436_()));
        this.m_146922_(pResult.m_82434_().m_122416_() * 90);
        BlockPos resultPos = pResult.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        SoundEvent event = state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), resultPos, (Entity)this).m_56775_();
        double speed = this.m_20184_().m_82553_();
        if (speed > 0.1) {
            this.m_9236_().m_6263_(null, pResult.m_82450_().f_82479_, pResult.m_82450_().f_82480_, pResult.m_82450_().f_82481_, event, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        this.inGround = true;
    }

    public void explode() {
        Entity target;
        Vec3 pos = this.m_20182_();
        if (this.onEntity && (target = EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(TARGET_UUID))) != null) {
            pos = target.m_20182_();
        }
        if (this.m_9236_() instanceof ServerLevel) {
            AABB aabb = new AABB(pos, pos).m_82400_(2.0);
            BlockPos.m_121921_((AABB)aabb).forEach(blockPos -> {
                float hard = this.m_9236_().m_8055_(blockPos).m_60734_().m_155943_();
                if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && hard != -1.0f) {
                    this.m_9236_().m_46961_(blockPos, true);
                }
            });
        }
        new CustomExplosion.Builder(this).attacker((Entity)this.m_269323_()).damage(((Integer)ExplosionConfig.C4_EXPLOSION_DAMAGE.get()).intValue()).radius(((Integer)ExplosionConfig.C4_EXPLOSION_RADIUS.get()).intValue()).position(pos).withParticleType(ParticleTool.ParticleType.HUGE).explode();
        this.m_146870_();
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return super.m_6972_(pPose).m_20388_(0.5f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public boolean m_6087_() {
        return true;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.C4_BOMB.get());
        if (((Boolean)this.m_20088_().m_135370_(IS_CONTROLLABLE)).booleanValue()) {
            stack.m_41784_().m_128379_("Control", true);
        }
        return stack;
    }

    public void defuse() {
        this.m_146870_();
        ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getItemStack());
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7967_((Entity)entity);
        }
    }

    public int getBombTick() {
        return (Integer)this.f_19804_.m_135370_(BOMB_TICK);
    }
}

