/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.PropModifier;
import com.atsuishio.superbwarfare.data.StringPropModifier;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.DamageReduce;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.data.gun.subdata.AmmoSlot;
import com.atsuishio.superbwarfare.data.gun.subdata.Attachment;
import com.atsuishio.superbwarfare.data.gun.subdata.Bolt;
import com.atsuishio.superbwarfare.data.gun.subdata.Charge;
import com.atsuishio.superbwarfare.data.gun.subdata.Perks;
import com.atsuishio.superbwarfare.data.gun.subdata.Reload;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.data.gun.value.BooleanValue;
import com.atsuishio.superbwarfare.data.gun.value.DoubleValue;
import com.atsuishio.superbwarfare.data.gun.value.IntValue;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.data.gun.value.StringEnumValue;
import com.atsuishio.superbwarfare.data.gun.value.StringValue;
import com.atsuishio.superbwarfare.event.GunEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;

public class GunData
implements DefaultDataSupplier<DefaultGunData> {
    public final ItemStack stack;
    public final GunItem item;
    public final CompoundTag tag;
    public final CompoundTag data;
    public final CompoundTag perkTag;
    public final CompoundTag attachmentTag;
    public final StringValue propertyOverrideString;
    public final String id;
    public final List<AmmoConsumer> ammoConsumers;
    public static final LoadingCache<ItemStack, GunData> dataCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<ItemStack, GunData>(){

        @NotNull
        public GunData load(@NotNull ItemStack stack) {
            return new GunData(stack);
        }
    });
    private final Map<GunProp<?>, Prop.PropModifyContext<GunData, DefaultGunData, ?>> tempModifications = new HashMap();
    private final Set<GunProp<?>> operatingProps = new HashSet();
    private final StringPropModifier<GunData, DefaultGunData> stringPropModifier = new StringPropModifier();
    public final IntValue selectedAmmoType;
    public final IntValue ammo;
    public final IntValue virtualAmmo;
    public final AmmoSlot ammoSlot;
    public final IntValue burstAmount;
    public final StringEnumValue<FireMode> fireMode;
    public final IntValue level;
    public final DoubleValue exp;
    public final DoubleValue upgradePoint;
    public final DoubleValue heat;
    public final BooleanValue overHeat;
    public final Reload reload;
    public final Charge charge;
    public final BooleanValue isEmpty;
    public final BooleanValue closeHammer;
    public final BooleanValue closeStrike;
    public final BooleanValue stopped;
    public final BooleanValue forceStop;
    public final IntValue loadIndex;
    public final BooleanValue holdOpen;
    public final BooleanValue hideBulletChain;
    public final IntValue sensitivity;
    public final Bolt bolt;
    public final Attachment attachment;
    public final Perks perk;

    private GunData(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof GunItem)) {
            throw new IllegalArgumentException("stack is not GunItem!");
        }
        GunItem gunItem = (GunItem)item;
        this.item = gunItem;
        this.stack = stack;
        this.id = GunData.getRegistryId(stack.m_41720_());
        this.tag = stack.m_41784_();
        this.data = this.getOrPut("GunData");
        this.perkTag = this.getOrPut("Perks");
        this.attachmentTag = this.getOrPut("Attachments");
        this.propertyOverrideString = new StringValue(this.data, "Override");
        this.selectedAmmoType = new IntValue(this.data, "SelectedAmmoType");
        this.reload = new Reload(this);
        this.charge = new Charge(this);
        this.bolt = new Bolt(this);
        this.attachment = new Attachment(this);
        this.perk = new Perks(this);
        this.ammo = new IntValue(this.data, "Ammo");
        this.virtualAmmo = new IntValue(this.data, "VirtualAmmo");
        this.ammoSlot = new AmmoSlot(this.data);
        this.burstAmount = new IntValue(this.data, "BurstAmount");
        this.level = new IntValue(this.data, "Level");
        this.exp = new DoubleValue(this.data, "Exp");
        this.upgradePoint = new DoubleValue(this.data, "UpgradePoint");
        this.isEmpty = new BooleanValue(this.data, "IsEmpty");
        this.closeHammer = new BooleanValue(this.data, "CloseHammer");
        this.closeStrike = new BooleanValue(this.data, "CloseStrike");
        this.stopped = new BooleanValue(this.data, "Stopped");
        this.forceStop = new BooleanValue(this.data, "ForceStop");
        this.loadIndex = new IntValue(this.data, "LoadIndex");
        this.holdOpen = new BooleanValue(this.data, "HoldOpen");
        this.hideBulletChain = new BooleanValue(this.data, "HideBulletChain");
        this.sensitivity = new IntValue(this.data, "Sensitivity");
        this.heat = new DoubleValue(this.data, "Heat");
        this.overHeat = new BooleanValue(this.data, "OverHeat");
        this.ammoConsumers = this.get(GunProp.AMMO_CONSUMER);
        FireMode defaultFireMode = this.get(GunProp.DEFAULT_FIRE_MODE);
        if (defaultFireMode == null) {
            defaultFireMode = FireMode.SEMI;
        }
        this.fireMode = new StringEnumValue<FireMode>(this.data, "FireMode", defaultFireMode, FireMode::fromValue);
    }

    private CompoundTag getOrPut(String name) {
        CompoundTag tag;
        if (!this.tag.m_128441_(name)) {
            tag = new CompoundTag();
            this.tag.m_128365_(name, (Tag)tag);
        } else {
            tag = this.tag.m_128469_(name);
        }
        return tag;
    }

    public boolean initialized() {
        return this.data.m_128403_("UUID");
    }

    public void initialize() {
        if (this.initialized()) {
            return;
        }
        this.data.m_128362_("UUID", UUID.randomUUID());
    }

    public static GunData create(Item item) {
        return GunData.from(new ItemStack((ItemLike)item));
    }

    public static GunData from(ItemStack stack) {
        return (GunData)dataCache.getUnchecked((Object)stack);
    }

    public GunItem item() {
        return this.item;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public CompoundTag tag() {
        return this.tag;
    }

    public CompoundTag data() {
        return this.data;
    }

    public CompoundTag perk() {
        return this.perkTag;
    }

    public CompoundTag attachment() {
        return this.attachmentTag;
    }

    public static DefaultGunData getDefault(String id) {
        boolean isDefault = !GunsTool.gunsData.containsKey(id);
        DefaultGunData data = GunsTool.gunsData.getOrDefault(id, new DefaultGunData());
        data.isDefaultData = isDefault;
        return data;
    }

    @Override
    public DefaultGunData getDefault() {
        return GunData.getDefault(this.id);
    }

    public static DefaultGunData getDefault(ItemStack stack) {
        return GunData.getDefault(stack.m_41720_());
    }

    public static DefaultGunData getDefault(Item item) {
        return GunData.getDefault(GunData.getRegistryId(item));
    }

    public static String getRegistryId(Item item) {
        String id = item.m_5524_();
        id = id.substring(id.indexOf(".") + 1).replace('.', ':');
        return id;
    }

    public <T> void appendTempModification(GunProp<T> prop, @Nullable Prop.PropModifyContext<GunData, DefaultGunData, T> modifier) {
        if (modifier == null) {
            return;
        }
        Prop.PropModifyContext<GunData, DefaultGunData, ?> current = this.tempModifications.get(prop);
        if (current == null) {
            this.setTempProperty(prop, modifier);
        } else {
            this.tempModifications.put(prop, (p, data, v) -> {
                Object value = current.apply(p, (GunData)data, v);
                return modifier.apply(p, (GunData)data, (Object)value);
            });
        }
    }

    public <T> void setTempProperty(GunProp<T> prop, @Nullable Prop.PropModifyContext<GunData, DefaultGunData, T> modifier) {
        if (modifier == null) {
            return;
        }
        this.tempModifications.put(prop, modifier);
    }

    public void clearTempModifications() {
        this.tempModifications.clear();
    }

    public <T> T get(GunProp<T> prop) {
        PropModifier modifier = prop.asModifier(this);
        if (this.operatingProps.contains(prop)) {
            Mod.LOGGER.warn("recursive computation for property {}", (Object)prop.name);
            return (T)modifier.compute();
        }
        this.operatingProps.add(prop);
        this.stringPropModifier.modifyPropertyByString(this.propertyOverrideString.get(), prop);
        modifier.apply(this.stringPropModifier);
        modifier.apply(this.item);
        modifier.apply(this.selectedAmmoConsumer((List)modifier.get(GunProp.AMMO_CONSUMER)));
        if (this.perk != null) {
            for (Perk.Type type : Perk.Type.values()) {
                Perk instance = this.perk.get(type);
                if (instance == null) continue;
                modifier.apply(instance);
            }
        }
        modifier.applyMap(this.tempModifications);
        this.operatingProps.remove(prop);
        return (T)modifier.compute();
    }

    public boolean hasInfiniteBackupAmmo(@Nullable Entity shooter) {
        Player player;
        return shooter instanceof Player && (player = (Player)shooter).m_7500_() || this.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.INFINITE || this.meleeOnly() || InventoryTool.hasCreativeAmmoBox(shooter);
    }

    public boolean useBackpackAmmo() {
        return this.get(GunProp.MAGAZINE) <= 0;
    }

    public double minZoom() {
        int scopeType = this.attachment.get(AttachmentType.SCOPE);
        return scopeType == 3 ? Math.max(this.getDefault().minZoom, 1.25) : 1.25;
    }

    public double maxZoom() {
        int scopeType = this.attachment.get(AttachmentType.SCOPE);
        return scopeType == 3 ? this.getDefault().maxZoom : 114514.0;
    }

    public double zoom() {
        if (this.minZoom() >= this.maxZoom()) {
            return this.get(GunProp.DEFAULT_ZOOM);
        }
        return Mth.m_14008_((double)this.get(GunProp.DEFAULT_ZOOM), (double)this.minZoom(), (double)this.maxZoom());
    }

    public AmmoConsumer selectedAmmoConsumer(List<AmmoConsumer> consumers) {
        if (consumers == null || consumers.isEmpty()) {
            return AmmoConsumer.INVALID;
        }
        return consumers.get(Mth.m_14045_((int)this.selectedAmmoType.get(), (int)0, (int)(consumers.size() - 1)));
    }

    public AmmoConsumer selectedAmmoConsumer() {
        return this.selectedAmmoConsumer(this.ammoConsumers);
    }

    public void changeAmmoConsumer(int index) {
        this.selectedAmmoType.set(Mth.m_14045_((int)index, (int)0, (int)(this.ammoConsumers.size() - 1)));
    }

    public boolean shouldStartReloading(@Nullable Entity entity) {
        return !this.reloading() && !this.useBackpackAmmo() && !this.hasEnoughAmmoToShoot(entity) && this.hasBackupAmmo(entity);
    }

    public boolean shouldStartBolt() {
        return this.bolt.actionTimer.get() == 0 && this.bolt.needed.get();
    }

    public void startReload() {
        this.reload.reloadStarter.markStart();
    }

    public void startBolt() {
        this.bolt.actionTimer.set(this.get(GunProp.BOLT_ACTION_TIME) + 1);
    }

    public boolean hasBackupAmmo(@Nullable Entity entity) {
        return this.countBackupAmmo(entity) > 0;
    }

    public int countBackupAmmo(@Nullable Entity entity) {
        Player player;
        if (entity == null) {
            return this.virtualAmmo.get();
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_() || InventoryTool.hasCreativeAmmoBox(entity)) {
            return Integer.MAX_VALUE;
        }
        return this.countBackupAmmoItem(entity) * this.selectedAmmoConsumer().loadAmount + this.virtualAmmo.get();
    }

    public int countBackupAmmo(@Nullable IItemHandler handler) {
        if (handler == null) {
            return this.virtualAmmo.get();
        }
        if (InventoryTool.hasCreativeAmmoBox(handler)) {
            return Integer.MAX_VALUE;
        }
        return this.countBackupAmmoItem(handler) * this.selectedAmmoConsumer().loadAmount + this.virtualAmmo.get();
    }

    public int countBackupAmmoItem(@Nullable Entity entity) {
        return this.selectedAmmoConsumer().count(entity);
    }

    public int countBackupAmmoItem(@Nullable IItemHandler handler) {
        return this.selectedAmmoConsumer().count(handler);
    }

    public void consumeBackupAmmo(@Nullable Entity entity, int count) {
        Player player;
        if (count <= 0 || entity instanceof Player && (player = (Player)entity).m_7500_() || InventoryTool.hasCreativeAmmoBox(entity)) {
            return;
        }
        if (this.virtualAmmo.get() > 0) {
            int consumed = Math.min(this.virtualAmmo.get(), count);
            this.virtualAmmo.add(-consumed);
            count -= consumed;
        }
        if (count <= 0 || entity == null) {
            return;
        }
        AmmoConsumer consumer = this.selectedAmmoConsumer();
        int loadAmount = consumer.loadAmount;
        if (count % loadAmount != 0) {
            int required;
            int consumed;
            if ((count -= (consumed = consumer.consume(this, entity, required = count / loadAmount + 1)) * loadAmount) <= 0) {
                this.virtualAmmo.add(-count);
            }
        } else {
            consumer.consume(this, entity, count / loadAmount);
        }
    }

    public void consumeBackupAmmo(@Nullable IItemHandler handler, int count) {
        if (count <= 0 || InventoryTool.hasCreativeAmmoBox(handler)) {
            return;
        }
        if (this.virtualAmmo.get() > 0) {
            int consumed = Math.min(this.virtualAmmo.get(), count);
            this.virtualAmmo.add(-consumed);
            count -= consumed;
        }
        if (count <= 0 || handler == null) {
            return;
        }
        AmmoConsumer consumer = this.selectedAmmoConsumer();
        int loadAmount = consumer.loadAmount;
        if (count % loadAmount != 0) {
            int required;
            int consumed;
            if ((count -= (consumed = consumer.consume(this, handler, required = count / loadAmount + 1)) * loadAmount) <= 0) {
                this.virtualAmmo.add(-count);
            }
        } else {
            consumer.consume(this, handler, count / loadAmount);
        }
    }

    public int currentAvailableShots(@Nullable Entity entity) {
        return this.currentAvailableAmmo(entity) / this.get(GunProp.AMMO_COST_PER_SHOOT);
    }

    public int currentAvailableAmmo(@Nullable Entity entity) {
        return this.useBackpackAmmo() ? this.countBackupAmmo(entity) : this.ammo.get();
    }

    public boolean hasEnoughAmmoToShoot(@Nullable Entity entity) {
        return this.get(GunProp.AMMO_COST_PER_SHOOT) <= this.currentAvailableAmmo(entity);
    }

    public void reloadAmmo(@Nullable Entity entity) {
        this.reloadAmmo(entity, false);
    }

    public void reloadAmmo(@Nullable Entity entity, boolean extraOne) {
        if (this.useBackpackAmmo()) {
            return;
        }
        int mag = this.get(GunProp.MAGAZINE);
        int ammo = this.ammo.get();
        int ammoNeeded = mag - ammo + (extraOne ? 1 : 0);
        if (ammo == 0 && this.get(GunProp.BOLT_ACTION_TIME) > 0) {
            this.bolt.needed.set(false);
        }
        int available = this.countBackupAmmo(entity);
        int ammoToAdd = Math.min(ammoNeeded, available);
        this.consumeBackupAmmo(entity, ammoToAdd);
        this.ammo.set(ammo + ammoToAdd);
        this.reload.setState(ReloadState.NOT_RELOADING);
    }

    public boolean canShoot(@Nullable Entity shooter) {
        return this.item.canShoot(this, shooter);
    }

    public void shoot(@NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, double spread, boolean zoom) {
        this.item.shoot(level, shootPosition, shootDirection, this, spread, zoom, null);
    }

    public void shoot(@NotNull Entity entity, double spread, boolean zoom, @Nullable UUID uuid) {
        this.item.shoot(this, entity, spread, zoom, uuid);
    }

    public void tick(@Nullable Entity shooter, boolean inMainHand) {
        GunEventHandler.gunTick(shooter, this, inMainHand);
    }

    public void withdrawAmmo(@NotNull Entity shooter) {
        int amount = this.virtualAmmo.get() + this.ammo.get();
        this.virtualAmmo.reset();
        this.ammo.reset();
        int itemAmount = amount / this.selectedAmmoConsumer().loadAmount;
        this.selectedAmmoConsumer().withdraw(shooter, itemAmount);
    }

    public void withdrawAmmo(@NotNull IItemHandler handler) {
        int amount = this.virtualAmmo.get() + this.ammo.get();
        int itemAmount = amount / this.selectedAmmoConsumer().loadAmount;
        this.selectedAmmoConsumer().withdraw(handler, itemAmount);
    }

    private static int getPerkPriority(String s) {
        if (s == null || s.isEmpty()) {
            return 2;
        }
        return switch (s.charAt(0)) {
            case '@' -> 0;
            case '!' -> 2;
            default -> 1;
        };
    }

    public List<Perk> availablePerks() {
        ArrayList<Perk> availablePerks = new ArrayList<Perk>();
        List<String> perkNames = this.get(GunProp.AVAILABLE_PERKS);
        if (perkNames == null || perkNames.isEmpty()) {
            return availablePerks;
        }
        ArrayList<String> sortedNames = new ArrayList<String>(perkNames);
        sortedNames.sort((s1, s2) -> {
            int p2;
            int p1 = GunData.getPerkPriority(s1);
            if (p1 != (p2 = GunData.getPerkPriority(s2))) {
                return Integer.compare(p1, p2);
            }
            return s1.compareTo((String)s2);
        });
        Set perks = RegistryManager.ACTIVE.getRegistry(ModPerks.PERK_KEY).getEntries();
        List<Perk> perkValues = perks.stream().map(Map.Entry::getValue).toList();
        List<String> perkKeys = perks.stream().map(perk -> ((ResourceKey)perk.getKey()).m_135782_().toString()).toList();
        for (String name : sortedNames) {
            if (name.startsWith("@")) {
                String type;
                switch (type = name.substring(1)) {
                    case "Ammo": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.AMMO).toList());
                        break;
                    }
                    case "Functional": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.FUNCTIONAL).toList());
                        break;
                    }
                    case "Damage": {
                        availablePerks.addAll(perkValues.stream().filter(perk -> perk.type == Perk.Type.DAMAGE).toList());
                    }
                }
                continue;
            }
            if (name.startsWith("!")) {
                String n = name.substring(1);
                int index = perkKeys.indexOf(n);
                if (index != -1) {
                    availablePerks.remove(perkValues.get(index));
                    continue;
                }
                Mod.LOGGER.info("Perk {} not found", (Object)n);
                continue;
            }
            int index = perkKeys.indexOf(name);
            if (index != -1) {
                availablePerks.add(perkValues.get(index));
                continue;
            }
            Mod.LOGGER.info("Perk {} not found", (Object)name);
        }
        return availablePerks;
    }

    public boolean canApplyPerk(Perk perk) {
        return this.availablePerks().contains(perk);
    }

    public DamageReduce getRawDamageReduce() {
        return this.getDefault().damageReduce;
    }

    public double getDamageReduceRate() {
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = this.perk.getInstance(type);
            if (instance == null) continue;
            return instance.perk().getModifiedDamageReduceRate(this.getRawDamageReduce());
        }
        return this.getRawDamageReduce().getRate();
    }

    public double getDamageReduceMinDistance() {
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = this.perk.getInstance(type);
            if (instance == null) continue;
            return instance.perk().getModifiedDamageReduceMinDistance(this.getRawDamageReduce());
        }
        return this.getRawDamageReduce().getMinDistance();
    }

    public boolean meleeOnly() {
        return this.get(GunProp.PROJECTILE_AMOUNT) <= 0 && this.get(GunProp.MELEE_DAMAGE) > 0.0;
    }

    public boolean canAdjustZoom() {
        return this.item.canAdjustZoom(this);
    }

    public boolean canSwitchScope() {
        return this.item.canSwitchScope(this);
    }

    public boolean reloading() {
        return this.reload.state() != ReloadState.NOT_RELOADING;
    }

    public boolean charging() {
        return this.charge.time() > 0;
    }
}

