/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.annotation.ServerOnly;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.DeserializeFromString;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.StringToObject;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.data.gun.GunPropertyModifier;
import com.atsuishio.superbwarfare.data.gun.ProjectileInfo;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmmoConsumer
implements DeserializeFromString,
GunPropertyModifier {
    @SerializedName(value="Ammo")
    public String ammo;
    @SerializedName(value="AmmoSlot")
    public String ammoSlot = "Default";
    @ServerOnly
    @SerializedName(value="Projectile")
    public StringToObject<ProjectileInfo> projectile = null;
    @SerializedName(value="Override")
    public JsonObject override = null;
    public transient AmmoConsumeType type = AmmoConsumeType.INVALID;
    public transient int loadAmount = 1;
    public static final AmmoConsumer INVALID = new AmmoConsumer();
    private transient boolean initialized = false;
    private transient Ammo playerAmmoType;
    private transient ItemStack stack = ItemStack.f_41583_;
    private final transient Map<GunProp<?>, Prop.PropModifyContext<GunData, DefaultGunData, ?>> modifiers = new HashMap();
    private static final Pattern AMMO_PATTERN = Pattern.compile("^(?<count>(\\d+)?)\\s*(?<prefix>[@#]?)(?<id>\\w+(:\\w+)?)\\s*(?<data>(\\{.*})?)$");
    private static final Gson GSON = DataLoader.GSON;

    public ItemStack stack() {
        return this.stack;
    }

    public boolean initialized() {
        return this.initialized;
    }

    @Override
    @NotNull
    public Map<GunProp<?>, Prop.PropModifyContext<GunData, DefaultGunData, ?>> getPropModifiers() {
        return this.modifiers;
    }

    public int consume(@NotNull GunData data, @NotNull Entity shooter, int count) {
        IItemHandler handler;
        Player player;
        if (count <= 0 || this.type == AmmoConsumeType.INFINITE || shooter instanceof Player && (player = (Player)shooter).m_7500_()) {
            return 0;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.INVALID) {
            Mod.LOGGER.warn("consume ammo failed: invalid AmmoConsumeType");
            return 0;
        }
        int consumed = 0;
        if (this.type == AmmoConsumeType.PLAYER_AMMO) {
            if (shooter instanceof Player) {
                Player player2 = (Player)shooter;
                if (this.playerAmmoType != null) {
                    int current = this.playerAmmoType.get(player2);
                    consumed = Math.min(current, count);
                    count -= consumed;
                    this.playerAmmoType.add(player2, -consumed);
                } else {
                    Mod.LOGGER.warn("consume player ammo failed: invalid player ammo type");
                }
            } else {
                Mod.LOGGER.warn("consume player ammo failed: invalid shooter");
            }
        }
        if ((handler = (IItemHandler)shooter.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null)) != null) {
            return consumed + this.consume(data, handler, count);
        }
        Mod.LOGGER.warn("consume ammo failed: invalid item handler for entity {}", (Object)shooter);
        return consumed;
    }

    public int consume(@NotNull GunData data, @NotNull IItemHandler handler, int count) {
        if (this.type == AmmoConsumeType.INVALID || this.type == AmmoConsumeType.INFINITE || this.type == AmmoConsumeType.EMPTY || count <= 0) {
            return 0;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.PLAYER_AMMO) {
            int consumed = InventoryTool.consumeAmmoItem(handler, this.playerAmmoType, count);
            int rest = consumed - count;
            data.virtualAmmo.add(rest);
            return count;
        }
        return InventoryTool.consumeItem(handler, stack -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.stack), count);
    }

    public int count(@Nullable Entity entity) {
        if (this.type == AmmoConsumeType.INFINITE) {
            return Integer.MAX_VALUE;
        }
        if (entity == null || this.type == AmmoConsumeType.EMPTY) {
            return 0;
        }
        if (!this.initialized) {
            this.init();
        }
        int playerAmmoCount = 0;
        if (this.type == AmmoConsumeType.PLAYER_AMMO && entity instanceof Player) {
            Player player = (Player)entity;
            playerAmmoCount = this.playerAmmoType.get(player);
        }
        return playerAmmoCount + this.count((IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null));
    }

    public int count(@Nullable IItemHandler handler) {
        if (this.type == AmmoConsumeType.INFINITE) {
            return Integer.MAX_VALUE;
        }
        if (handler == null || this.type == AmmoConsumeType.EMPTY) {
            return 0;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.ITEM) {
            return InventoryTool.countItem(handler, stack -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.stack));
        }
        return InventoryTool.countAmmoItem(handler, this.playerAmmoType);
    }

    public int withdraw(@NotNull Entity shooter, int count) {
        if (this.type == AmmoConsumeType.INVALID || this.type == AmmoConsumeType.INFINITE || this.type == AmmoConsumeType.EMPTY || count <= 0) {
            return 0;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.type == AmmoConsumeType.PLAYER_AMMO) {
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                if (this.playerAmmoType != null) {
                    this.playerAmmoType.add(player, count);
                    return count;
                }
                Mod.LOGGER.warn("withdraw player ammo failed: invalid player ammo type");
            } else {
                Mod.LOGGER.warn("withdraw player ammo failed: invalid shooter");
            }
        } else {
            if (shooter instanceof Player) {
                Player player = (Player)shooter;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack.m_255036_(count));
                return count;
            }
            IItemHandler itemHandler = shooter.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
            if (itemHandler != null) {
                return this.withdraw(itemHandler, count);
            }
            Mod.LOGGER.warn("withdraw ammo failed: invalid item handler");
        }
        return 0;
    }

    public int withdraw(@NotNull IItemHandler handler, int count) {
        if (this.type == AmmoConsumeType.INVALID || this.type == AmmoConsumeType.INFINITE || this.type == AmmoConsumeType.EMPTY || count <= 0) {
            return 0;
        }
        if (!this.initialized) {
            this.init();
        }
        ItemStack copiedStack = this.stack.m_255036_(count);
        ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)copiedStack, (boolean)false);
        int inserted = count - result.m_41613_();
        if (!result.m_41619_()) {
            Mod.LOGGER.warn("trying to withdraw ammo {} with count {}, but only {} is inserted", (Object)copiedStack, (Object)count, (Object)inserted);
        }
        return inserted;
    }

    private void parseOverrideValues() {
        if (this.override != null) {
            for (Map.Entry element : this.override.entrySet()) {
                String key = (String)element.getKey();
                Object prop = GunProp.getByName(key);
                if (prop == null) {
                    Mod.LOGGER.warn("invalid override key: {}", (Object)key);
                    continue;
                }
                try {
                    Object parsedValue = GSON.fromJson(((JsonElement)element.getValue()).toString(), ((Prop)prop).getFieldType());
                    this.setProperty((GunProp)prop, (T value) -> parsedValue);
                }
                catch (Exception exception) {
                    Mod.LOGGER.error("invalid override value for key {}: {}", (Object)key, element.getValue());
                }
            }
        }
    }

    public void init() {
        this.parseOverrideValues();
        if (this.projectile != null) {
            this.setProperty(GunProp.PROJECTILE, (T value) -> (ProjectileInfo)this.projectile.value);
        }
        this.type = AmmoConsumeType.INVALID;
        if (this.ammo == null || this.ammo.isEmpty() || this.ammo.toLowerCase(Locale.ROOT).equals("empty")) {
            this.type = AmmoConsumeType.EMPTY;
            return;
        }
        if (this.ammo.toLowerCase(Locale.ROOT).equals("infinity") || this.ammo.toLowerCase(Locale.ROOT).equals("infinite")) {
            this.type = AmmoConsumeType.INFINITE;
            return;
        }
        Matcher matcher = AMMO_PATTERN.matcher(this.ammo.trim());
        if (!matcher.matches()) {
            Mod.LOGGER.warn("invalid ammo value: {}", (Object)this.ammo);
            return;
        }
        String numStr = matcher.group("count").trim();
        this.loadAmount = Mth.m_14045_((int)(numStr.isEmpty() ? 1 : Integer.parseInt(numStr)), (int)1, (int)Integer.MAX_VALUE);
        String prefix = matcher.group("prefix");
        String id = matcher.group("id");
        String data = matcher.group("data");
        if ("@".equals(prefix)) {
            this.playerAmmoType = Ammo.getType(id);
            if (this.playerAmmoType == null) {
                Mod.LOGGER.warn("invalid player ammo type: {}", (Object)id);
                return;
            }
            this.type = AmmoConsumeType.PLAYER_AMMO;
        } else {
            ResourceLocation location = ResourceLocation.m_135820_((String)id);
            if (location == null) {
                Mod.LOGGER.warn("invalid item id: {}", (Object)id);
                return;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (item == null || item == Items.f_41852_) {
                Mod.LOGGER.warn("invalid item: {}", (Object)id);
                return;
            }
            this.stack = new ItemStack((ItemLike)item);
            if (!data.isEmpty()) {
                try {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128365_("tag", (Tag)TagParser.m_129359_((String)data));
                    tag.m_128359_("id", location.toString());
                    tag.m_128405_("Count", 1);
                    this.stack = ItemStack.m_41712_((CompoundTag)tag);
                }
                catch (Exception exception) {
                    Mod.LOGGER.warn("invalid item data {}: {}", (Object)data, (Object)exception.getMessage());
                    return;
                }
            }
            this.type = AmmoConsumeType.ITEM;
        }
        this.initialized = true;
    }

    @Override
    public void deserializeFromString(String str) {
        this.ammo = str;
        this.init();
    }

    public Ammo getPlayerAmmoType() {
        return this.playerAmmoType;
    }

    public static enum AmmoConsumeType {
        INVALID,
        EMPTY,
        INFINITE,
        PLAYER_AMMO,
        ITEM;

    }
}

