/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.drone_attachment;

import com.atsuishio.superbwarfare.data.IDBasedData;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class DroneAttachmentData
implements IDBasedData {
    @SerializedName(value="Item")
    public String itemID = "";
    @SerializedName(value="Entity")
    private String entity = "";
    @SerializedName(value="DisplayEntity")
    private String displayEntity = "";
    @SerializedName(value="DropEntity")
    private String dropEntity = "";
    @SerializedName(value="DropPosition")
    private float[] dropPosition = new float[]{0.0f, -0.09f, 0.0f};
    @SerializedName(value="Data")
    public JsonObject data;
    @SerializedName(value="DisplayData")
    private JsonObject displayData;
    @SerializedName(value="DropData")
    private JsonObject dropData;
    @SerializedName(value="Count")
    private int count = 1;
    @SerializedName(value="IsKamikaze")
    public boolean isKamikaze = true;
    @SerializedName(value="HitDamage")
    public float hitDamage = 0.0f;
    @SerializedName(value="ExplosionDamage")
    public float explosionDamage = 0.0f;
    @SerializedName(value="ExplosionRadius")
    public float explosionRadius = 0.0f;
    @SerializedName(value="Scale")
    private float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    @SerializedName(value="Offset")
    private float[] offset = new float[]{0.0f, 0.0f, 0.0f};
    @SerializedName(value="Rotation")
    private float[] rotation = new float[]{0.0f, 0.0f, 0.0f};
    @SerializedName(value="XLength")
    public float xLength = 0.1f;
    @SerializedName(value="ZLength")
    public float zLength = 0.35f;
    @SerializedName(value="TickCount")
    public int tickCount = -1;

    public String displayEntity() {
        if (!this.entity.isEmpty()) {
            return this.entity;
        }
        return this.displayEntity.isEmpty() ? this.dropEntity : this.displayEntity;
    }

    public String dropEntity() {
        if (!this.entity.isEmpty()) {
            return this.entity;
        }
        return this.dropEntity.isEmpty() ? this.displayEntity : this.dropEntity;
    }

    public float[] dropPosition() {
        float[] fArray;
        if (this.dropPosition != null && this.dropPosition.length < 3) {
            float[] fArray2 = new float[3];
            fArray2[0] = 0.0f;
            fArray2[1] = -0.09f;
            fArray = fArray2;
            fArray2[2] = 0.0f;
        } else {
            fArray = this.dropPosition;
        }
        return fArray;
    }

    public JsonObject displayData() {
        if (this.data != null) {
            return this.data;
        }
        return this.displayData != null ? this.displayData : this.dropData;
    }

    public JsonObject dropData() {
        if (this.data != null) {
            return this.data;
        }
        return this.dropData != null ? this.dropData : this.displayData;
    }

    @Override
    public String getId() {
        return this.itemID;
    }

    public int count() {
        return this.isKamikaze ? 1 : Math.max(1, this.count);
    }

    public float[] scale() {
        float[] fArray;
        if (this.scale != null && this.scale.length < 3) {
            float[] fArray2 = new float[3];
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray = fArray2;
            fArray2[2] = 1.0f;
        } else {
            fArray = this.scale;
        }
        return fArray;
    }

    public float[] offset() {
        float[] fArray;
        if (this.offset != null && this.offset.length < 3) {
            float[] fArray2 = new float[3];
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            fArray = fArray2;
            fArray2[2] = 0.0f;
        } else {
            fArray = this.offset;
        }
        return fArray;
    }

    public float[] rotation() {
        float[] fArray;
        if (this.rotation != null && this.rotation.length < 3) {
            float[] fArray2 = new float[3];
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            fArray = fArray2;
            fArray2[2] = 0.0f;
        } else {
            fArray = this.rotation;
        }
        return fArray;
    }
}

