/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.Prop;
import com.atsuishio.superbwarfare.data.PropertyModifier;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PropModifier<DATA extends DefaultDataSupplier<DEFAULT_DATA>, DEFAULT_DATA, FIELD> {
    private final Prop<DATA, DEFAULT_DATA, FIELD> prop;
    private final DATA data;
    private final Prop.PropModifyContext<DATA, DEFAULT_DATA, FIELD> limiter;
    private final Map<Prop<DATA, DEFAULT_DATA, ?>, Object> props = new HashMap();

    PropModifier(Prop<DATA, DEFAULT_DATA, FIELD> prop, DATA data, @Nullable Prop.PropModifyContext<DATA, DEFAULT_DATA, FIELD> limiter) {
        this.prop = prop;
        this.data = data;
        this.limiter = limiter;
    }

    public PropModifier<DATA, DEFAULT_DATA, FIELD> apply(@Nullable PropertyModifier<DATA, DEFAULT_DATA> modifier) {
        if (modifier == null) {
            return this;
        }
        Map a = modifier.getPropModifiers();
        for (Map.Entry entry : a.entrySet()) {
            Prop prop = (Prop)entry.getKey();
            Prop.PropModifyContext<DATA, DEFAULT_DATA, ?> func = entry.getValue();
            this.props.put(prop, func.apply(this, this.data, this.get(prop)));
        }
        return this;
    }

    public void applyMap(@Nullable Map<Prop<DATA, DEFAULT_DATA, ?>, Prop.PropModifyContext<DATA, DEFAULT_DATA, ?>> modifier) {
        if (modifier == null) {
            return;
        }
        for (Map.Entry<Prop<DATA, DEFAULT_DATA, ?>, Prop.PropModifyContext<DATA, DEFAULT_DATA, ?>> entry : modifier.entrySet()) {
            Prop<DATA, DEFAULT_DATA, ?> key = entry.getKey();
            Prop.PropModifyContext<DATA, DEFAULT_DATA, ?> value = entry.getValue();
            this.props.put(entry.getKey(), value.apply(this, this.data, this.get(key)));
        }
    }

    public <F> F get(Prop<DATA, DEFAULT_DATA, F> prop) {
        return (F)DataLoader.processValue(this.props.computeIfAbsent(prop, aa -> aa.getDefault(this.data.getDefault())));
    }

    public FIELD compute() {
        FIELD result = this.get(this.prop);
        if (this.limiter != null) {
            result = this.limiter.apply(this, this.data, result);
        }
        return (FIELD)DataLoader.processValue(result);
    }
}

