/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.PropModifier;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Prop<DATA extends DefaultDataSupplier<DEFAULT_DATA>, DEFAULT_DATA, FIELD> {
    public static final List<Prop<?, ?, ?>> props = new ArrayList();
    public final Class<DEFAULT_DATA> rawDataType;
    public final String name;
    protected final Field field;
    public Function<DEFAULT_DATA, FIELD> specialSupplier;
    public PropModifyContext<DATA, DEFAULT_DATA, FIELD> limiter;

    protected Prop(Class<DEFAULT_DATA> rawDataType, String name) {
        this.rawDataType = rawDataType;
        this.name = name;
        try {
            this.field = Arrays.stream(this.rawDataType.getFields()).filter(f -> {
                SerializedName annotation = f.getAnnotation(SerializedName.class);
                return annotation != null && annotation.value().equals(this.name);
            }).findFirst().orElseThrow();
            this.field.setAccessible(true);
        }
        catch (Exception exception) {
            Mod.LOGGER.error("Could not find field {} in RAW_DATA!", (Object)name);
            throw new RuntimeException(exception);
        }
        props.add(this);
    }

    public Type getFieldType() {
        return this.field.getGenericType();
    }

    protected <T extends Prop<DATA, DEFAULT_DATA, FIELD>> T withSupplier(Function<DEFAULT_DATA, FIELD> supplier) {
        this.specialSupplier = supplier;
        return (T)this;
    }

    protected <T extends Prop<DATA, DEFAULT_DATA, FIELD>> T withLimiter(PropModifyContext<DATA, DEFAULT_DATA, FIELD> limiter) {
        this.limiter = limiter;
        return (T)this;
    }

    protected <T extends Prop<DATA, DEFAULT_DATA, FIELD>> T withLimiter(Function<FIELD, FIELD> limiter) {
        return this.withLimiter((PropModifier<DATA, ?, FIELD> prop, DATA data, FIELD value) -> limiter.apply(value));
    }

    protected <T extends Prop<DATA, DEFAULT_DATA, FIELD>> T withLimiter(BiFunction<DATA, FIELD, FIELD> limiter) {
        return this.withLimiter((PropModifier<DATA, ?, FIELD> prop, DATA data, FIELD value) -> limiter.apply(data, value));
    }

    public FIELD getDefault(DEFAULT_DATA data) {
        if (this.specialSupplier != null) {
            return this.specialSupplier.apply(data);
        }
        try {
            return (FIELD)DataLoader.processValue(this.field.get(data));
        }
        catch (Exception exception) {
            Mod.LOGGER.error("Could not get field {} in RAW_DATA!", (Object)this.name);
            throw new RuntimeException(exception);
        }
    }

    public PropModifier<DATA, DEFAULT_DATA, FIELD> asModifier(DATA data) {
        return new PropModifier<DATA, DEFAULT_DATA, FIELD>(this, data, this.limiter);
    }

    @Nullable
    public static <T extends Prop<?, ?, ?>> T getByName(String name) {
        return (T)((Prop)props.stream().filter(p -> p.name.equals(name)).findFirst().orElse(null));
    }

    @FunctionalInterface
    public static interface PropModifyContext<DATA extends DefaultDataSupplier<DEFAULT_DATA>, DEFAULT_DATA, FIELD> {
        public FIELD apply(@NotNull PropModifier<DATA, ?, FIELD> var1, @NotNull DATA var2, @NotNull FIELD var3);
    }
}

