/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.screens.component.AssembleButton;
import com.atsuishio.superbwarfare.client.screens.component.CategoryButton;
import com.atsuishio.superbwarfare.client.screens.component.PageButton;
import com.atsuishio.superbwarfare.client.screens.component.RecipeButton;
import com.atsuishio.superbwarfare.compat.jei.JeiCompatHolder;
import com.atsuishio.superbwarfare.compat.jei.SbwJEIPlugin;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.menu.VehicleAssemblingMenu;
import com.atsuishio.superbwarfare.network.message.send.AssembleVehicleMessage;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingIngredient;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import com.atsuishio.superbwarfare.tools.animation.AnimationCurves;
import com.atsuishio.superbwarfare.tools.animation.ValueAnimator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class VehicleAssemblingScreen
extends AbstractContainerScreen<VehicleAssemblingMenu> {
    public static final ResourceLocation TEXTURE = Mod.loc("textures/gui/vehicle_assembling_table.png");
    public static final int IMAGE_SIZE = 356;
    public static final int PAGE_SIZE = 9;
    public static final float DEFAULT_MODEL_SCALE = 50.0f;
    public static final float MIN_MODEL_SCALE = 10.0f;
    public static final float MAX_MODEL_SCALE = 200.0f;
    public static final int DEFAULT_MODEL_X = 234;
    public static final int DEFAULT_MODEL_Y = 80;
    private final Map<VehicleAssemblingRecipe.Category, List<ResourceLocation>> recipes = Maps.newLinkedHashMap();
    private VehicleAssemblingRecipe.Category currentCategory = VehicleAssemblingRecipe.Category.LAND;
    @Nullable
    private List<ResourceLocation> currentRecipes = new ArrayList<ResourceLocation>();
    @Nullable
    private VehicleAssemblingRecipe currentRecipe = null;
    @Nullable
    private Int2IntArrayMap materialCount;
    private int pageIndex = 0;
    private String entityNameCache = "";
    private Entity entityCache = null;
    private final ValueAnimator<Float> scaleAnimator = (ValueAnimator)new ValueAnimator<Float>(300L, Float.valueOf(50.0f)).animation(AnimationCurves.EASE_OUT_EXPO);
    private final ValueAnimator<Vec2> modelPosAnimator = (ValueAnimator)new ValueAnimator<Vec2>(300L, new Vec2(234.0f, 80.0f)).animation(AnimationCurves.EASE_OUT_EXPO);

    public VehicleAssemblingScreen(VehicleAssemblingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 356;
        this.f_97727_ = 181;
        this.initRecipes();
        this.pageIndex = 0;
        this.currentRecipe = this.getRecipeById(this.currentRecipes == null || this.currentRecipes.isEmpty() ? null : this.currentRecipes.get(0));
        this.calculateMaterialCount(this.currentRecipe);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initRecipes();
        this.m_169413_();
        int posX = (this.f_96543_ - this.f_97726_) / 2;
        int posY = (this.f_96544_ - this.f_97727_) / 2;
        this.addCategoryButtons(posX, posY);
        this.addRecipeButtons(posX, posY);
        this.addPageButtons(posX, posY);
        this.addAssembleButton(posX, posY);
        this.addScaleButtons(posX, posY);
    }

    public void initRecipes() {
        this.recipes.clear();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List recipeList = recipeManager.m_44013_((RecipeType)ModRecipes.VEHICLE_ASSEMBLING_TYPE.get());
        for (VehicleAssemblingRecipe recipe : recipeList) {
            this.recipes.computeIfAbsent(recipe.getCategory(), k -> Lists.newArrayList()).add(recipe.m_6423_());
        }
        this.currentRecipes = this.recipes.get((Object)this.currentCategory);
    }

    public void addCategoryButtons(int posX, int posY) {
        int i = 0;
        for (VehicleAssemblingRecipe.Category category : VehicleAssemblingRecipe.Category.values()) {
            CategoryButton button = new CategoryButton(posX, posY + 21 + i * 23, category, b -> {
                this.currentCategory = category;
                this.currentRecipes = this.recipes.get((Object)category);
                this.currentRecipe = this.getRecipeById(this.currentRecipes == null || this.currentRecipes.isEmpty() ? null : this.currentRecipes.get(0));
                this.pageIndex = 0;
                this.calculateMaterialCount(this.currentRecipe);
                this.m_7856_();
            });
            if (this.currentCategory.equals((Object)category)) {
                button.setSelected(true);
            }
            this.m_142416_((GuiEventListener)button);
            ++i;
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.currentRecipe != null) {
            this.renderModel(this.currentRecipe, guiGraphics);
            this.renderRecipeInfo(this.currentRecipe, guiGraphics, mouseX, mouseY);
            guiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"container.superbwarfare.vehicle_assembling_table.count", (Object[])new Object[]{this.currentRecipe.getResult().getResult().m_41613_()}), this.f_97735_ + 214, this.f_97736_ + 164, 0x555555, false);
        }
        if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
            this.renderIngredients(guiGraphics, mouseX, mouseY);
        }
        this.f_169369_.stream().filter(w -> w instanceof RecipeButton || w instanceof CategoryButton).forEach(w -> {
            if (w instanceof RecipeButton) {
                RecipeButton recipeButton = (RecipeButton)((Object)w);
                recipeButton.renderTooltips(guiGraphics, mouseX, mouseY);
            }
            if (w instanceof CategoryButton) {
                CategoryButton categoryButton = (CategoryButton)((Object)w);
                categoryButton.renderTooltips(guiGraphics, mouseX, mouseY);
            }
        });
    }

    public void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280163_(TEXTURE, i, j, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 356, 356);
    }

    protected void m_280003_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    @Nullable
    private VehicleAssemblingRecipe getRecipeById(ResourceLocation recipeId) {
        RecipeManager recipeManager;
        Recipe recipe;
        if (recipeId == null) {
            return null;
        }
        if (Minecraft.m_91087_().f_91073_ != null && (recipe = (Recipe)(recipeManager = Minecraft.m_91087_().f_91073_.m_7465_()).m_44043_(recipeId).orElse(null)) instanceof VehicleAssemblingRecipe) {
            VehicleAssemblingRecipe assemblingRecipe = (VehicleAssemblingRecipe)recipe;
            return assemblingRecipe;
        }
        return null;
    }

    public void calculateMaterialCount(@Nullable VehicleAssemblingRecipe recipe) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || recipe == null) {
            return;
        }
        List<VehicleAssemblingIngredient> ingredients = recipe.getInputs();
        int size = ingredients.size();
        this.materialCount = new Int2IntArrayMap(size);
        for (int i = 0; i < size; ++i) {
            VehicleAssemblingIngredient ingredient = ingredients.get(i);
            int count = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41619_() || !ingredient.getIngredient().test(stack)) continue;
                count += stack.m_41613_();
            }
            this.materialCount.put(i, count);
        }
    }

    public void addRecipeButtons(int posX, int posY) {
        if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
            ResourceLocation id;
            VehicleAssemblingRecipe recipe;
            int index;
            for (int i = 0; i < 9 && (index = i + this.pageIndex * 9) < this.currentRecipes.size() && (recipe = this.getRecipeById(id = this.currentRecipes.get(index))) != null; ++i) {
                RecipeButton button = (RecipeButton)this.m_142416_((GuiEventListener)new RecipeButton(posX + 26, posY + 21 + i * 17, recipe.getResult().getResult(), b -> {
                    this.currentRecipe = recipe;
                    this.calculateMaterialCount(recipe);
                    this.m_7856_();
                }));
                if (this.currentRecipe == null || !recipe.m_6423_().equals((Object)this.currentRecipe.m_6423_())) continue;
                button.setSelected(true);
            }
        }
    }

    private void renderIngredients(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.currentRecipe == null) {
            return;
        }
        List<VehicleAssemblingIngredient> inputs = this.currentRecipe.getInputs();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                int index = i * 4 + j;
                if (index >= inputs.size()) {
                    return;
                }
                int posX = x + 215 + j * 34;
                int posY = y + 118 + i * 14;
                VehicleAssemblingIngredient input = inputs.get(index);
                Ingredient ingredient = input.getIngredient();
                ItemStack[] items = ingredient.m_43908_();
                if (items.length == 0) continue;
                int itemIndex = (int)(System.currentTimeMillis() / 1000L) % items.length;
                ItemStack itemStack = items[itemIndex];
                PoseStack pose = guiGraphics.m_280168_();
                pose.m_85836_();
                pose.m_85841_(0.8f, 0.8f, 1.0f);
                guiGraphics.m_280203_(itemStack, (int)((float)posX * 1.25f), (int)((float)posY * 1.25f));
                pose.m_85849_();
                if (mouseX >= posX && mouseY >= posY && (float)mouseX < (float)posX + 12.8f && (float)mouseY < (float)posY + 12.8f) {
                    guiGraphics.m_280153_(this.f_96547_, itemStack, mouseX, mouseY);
                }
                pose.m_85836_();
                pose.m_85841_(0.5f, 0.5f, 1.0f);
                pose.m_252880_(0.0f, 0.0f, 200.0f);
                int count = input.getCount();
                if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_()) {
                    MutableComponent text = Component.m_237113_((String)(count + "/\u221e"));
                    guiGraphics.m_280614_(this.f_96547_, (Component)text, (posX + 14) * 2, (posY + 8) * 2, 2896193, false);
                } else {
                    int hasCount = 0;
                    if (this.materialCount != null && index < this.materialCount.size()) {
                        hasCount = this.materialCount.get(index);
                    }
                    int color = hasCount >= count ? 2896193 : 16010593;
                    MutableComponent text = Component.m_237113_((String)(count + "/" + hasCount));
                    guiGraphics.m_280614_(this.f_96547_, (Component)text, (posX + 14) * 2, (posY + 8) * 2, color, false);
                }
                pose.m_85849_();
            }
        }
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pMouseX >= (double)(this.f_97735_ + 114) && pMouseX <= (double)(this.f_97735_ + 354) && pMouseY >= (double)this.f_97736_ && pMouseY <= (double)(this.f_97736_ + 99)) {
            Vec2 newVec = this.modelPosAnimator.newValue();
            double posX = Mth.m_14008_((double)((double)newVec.f_82470_ + pDragX), (double)34.0, (double)434.0);
            double posY = Mth.m_14008_((double)((double)newVec.f_82471_ + pDragY), (double)-70.0, (double)230.0);
            this.modelPosAnimator.update(new Vec2((float)posX, (float)posY));
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)(this.f_97735_ + 26) && pMouseX <= (double)(this.f_97735_ + 106) && pMouseY >= (double)(this.f_97736_ + 21) && pMouseY <= (double)(this.f_97736_ + 175)) {
            if (pDelta > 0.0) {
                this.pageIndex = Math.max(0, this.pageIndex - 1);
            } else if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
                this.pageIndex = Math.min((this.currentRecipes.size() - 1) / 9, this.pageIndex + 1);
            }
            this.m_7856_();
            return true;
        }
        if (pMouseX >= (double)(this.f_97735_ + 114) && pMouseX <= (double)(this.f_97735_ + 354) && pMouseY >= (double)this.f_97736_ && pMouseY <= (double)(this.f_97736_ + 99)) {
            float targetScale = pDelta > 0.0 ? Math.min(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) + 20.0f, 200.0f) : Math.max(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) - 20.0f, 10.0f);
            this.scaleAnimator.update(Float.valueOf(targetScale));
            this.scaleAnimator.beginForward(System.currentTimeMillis());
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        Optional<IngredientArea> ingredientArea;
        List<IngredientArea> list = this.getIngredientAreas();
        if (!list.isEmpty() && pMouseX >= (double)(this.f_97735_ + 214) && pMouseY >= (double)(this.f_97736_ + 117) && pMouseX <= (double)(this.f_97735_ + 350) && pMouseY <= (double)(this.f_97736_ + 160) && JeiCompatHolder.hasJEI() && (ingredientArea = list.stream().filter(area -> area.contains(pMouseX, pMouseY)).findFirst()).isPresent()) {
            ItemStack[] items = ingredientArea.get().ingredient.m_43908_();
            int itemIndex = (int)(System.currentTimeMillis() / 1000L) % items.length;
            SbwJEIPlugin.showRecipes(items[itemIndex]);
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public void addPageButtons(int posX, int posY) {
        PageButton left = (PageButton)this.m_142416_((GuiEventListener)new PageButton(posX + 95, posY - 1, true, b -> {
            this.pageIndex = Math.max(0, this.pageIndex - 1);
            this.m_7856_();
        }));
        PageButton right = (PageButton)this.m_142416_((GuiEventListener)new PageButton(posX + 103, posY - 1, false, b -> {
            if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
                this.pageIndex = Math.min((this.currentRecipes.size() - 1) / 9, this.pageIndex + 1);
                this.m_7856_();
            }
        }));
        if (this.currentRecipes != null && !this.currentRecipes.isEmpty()) {
            left.f_93623_ = this.pageIndex > 0;
            right.f_93623_ = this.pageIndex < (this.currentRecipes.size() - 1) / 9;
        } else {
            left.f_93623_ = false;
            right.f_93623_ = false;
        }
    }

    public void addAssembleButton(int posX, int posY) {
        this.m_142416_((GuiEventListener)new AssembleButton(posX + 295, posY + 163, b -> {
            if (this.currentRecipe == null || this.materialCount == null) {
                return;
            }
            List<VehicleAssemblingIngredient> inputs = this.currentRecipe.getInputs();
            int size = inputs.size();
            for (int i = 0; i < size; ++i) {
                boolean isCreative;
                if (i >= this.materialCount.size()) {
                    return;
                }
                int hasCount = this.materialCount.get(i);
                int needCount = inputs.get(i).getCount();
                boolean bl = isCreative = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_7500_();
                if (hasCount >= needCount || isCreative) continue;
                return;
            }
            Mod.PACKET_HANDLER.sendToServer((Object)new AssembleVehicleMessage(this.currentRecipe.m_6423_(), ((VehicleAssemblingMenu)this.f_97732_).f_38840_));
        }));
    }

    public void finishAssembling() {
        if (this.currentRecipe != null) {
            this.calculateMaterialCount(this.currentRecipe);
        }
        this.m_7856_();
    }

    public void addScaleButtons(int posX, int posY) {
        this.m_142416_((GuiEventListener)new ImageButton(posX + 324, posY + 90, 9, 9, 149, 182, 10, TEXTURE, 356, 356, b -> {
            long time = System.currentTimeMillis();
            this.scaleAnimator.update(Float.valueOf(50.0f));
            this.scaleAnimator.beginForward(time);
            this.modelPosAnimator.update(new Vec2(234.0f, 80.0f));
            this.modelPosAnimator.beginForward(time);
        }));
        this.m_142416_((GuiEventListener)new ImageButton(posX + 334, posY + 90, 9, 9, 159, 182, 10, TEXTURE, 356, 356, b -> {
            this.scaleAnimator.update(Float.valueOf(Math.max(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) - 20.0f, 10.0f)));
            this.scaleAnimator.beginForward(System.currentTimeMillis());
        }));
        this.m_142416_((GuiEventListener)new ImageButton(posX + 344, posY + 90, 9, 9, 169, 182, 10, TEXTURE, 356, 356, b -> {
            this.scaleAnimator.update(Float.valueOf(Math.min(this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis()) + 20.0f, 200.0f)));
            this.scaleAnimator.beginForward(System.currentTimeMillis());
        }));
    }

    public void renderModel(VehicleAssemblingRecipe recipe, GuiGraphics guiGraphics) {
        CompoundTag tag;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        RenderHelper.markGuiRenderTimestamp();
        ItemStack stack = recipe.getResult().getResult();
        Entity renderEntity = null;
        if (stack.m_150930_((Item)ModItems.CONTAINER.get()) && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_("EntityType")) {
            String key = tag.m_128461_("EntityType");
            if (this.entityNameCache.equals(key) && this.entityCache != null) {
                renderEntity = this.entityCache;
            } else {
                renderEntity = EntityType.m_20632_((String)key).map(type -> type.m_20615_((Level)level)).orElse(null);
                if (renderEntity != null) {
                    this.entityNameCache = key;
                    this.entityCache = renderEntity;
                }
            }
        }
        if (renderEntity == null) {
            this.renderDefaultItemModel(stack);
        } else {
            this.renderEntityModel(guiGraphics, renderEntity);
        }
    }

    private void renderDefaultItemModel(ItemStack stack) {
        float rotationPeriod = 8.0f;
        int width = 240;
        int height = 99;
        float rotPitch = 15.0f;
        Window window = Minecraft.m_91087_().m_91268_();
        double windowGuiScale = window.m_85449_();
        int scissorX = (int)((double)(this.f_97735_ + 114) * windowGuiScale);
        int scissorY = (int)((double)window.m_85442_() - (double)(this.f_97736_ + height) * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)((double)height * windowGuiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        Vec2 oldVec = this.modelPosAnimator.oldValue();
        Vec2 newVec = this.modelPosAnimator.newValue();
        float xOffset = this.modelPosAnimator.lerp(oldVec.f_82470_, newVec.f_82470_, System.currentTimeMillis());
        float yOffset = this.modelPosAnimator.lerp(oldVec.f_82471_, newVec.f_82471_, System.currentTimeMillis());
        posestack.m_252880_((float)this.f_97735_ + xOffset, (float)this.f_97736_ + yOffset - 20.0f, 200.0f);
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        float currentScale = this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis());
        posestack.m_85841_(currentScale, currentScale, currentScale);
        float rot = (float)(System.currentTimeMillis() % (long)((int)(rotationPeriod * 1000.0f))) * (360.0f / (rotationPeriod * 1000.0f));
        posestack.m_252781_(Axis.f_252529_.m_252977_(rotPitch));
        posestack.m_252781_(Axis.f_252436_.m_252977_(rot));
        RenderSystem.applyModelViewMatrix();
        PoseStack tmpPose = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, tmpPose, (MultiBufferSource)bufferSource, null, 0);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableScissor();
    }

    private void renderEntityModel(GuiGraphics guiGraphics, Entity renderEntity) {
        if (renderEntity == null) {
            return;
        }
        PoseStack posestack = guiGraphics.m_280168_();
        int width = 240;
        int height = 99;
        Window window = Minecraft.m_91087_().m_91268_();
        double windowGuiScale = window.m_85449_();
        int scissorX = (int)((double)(this.f_97735_ + 114) * windowGuiScale);
        int scissorY = (int)((double)window.m_85442_() - (double)(this.f_97736_ + height) * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)((double)height * windowGuiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        posestack.m_85836_();
        Vec2 oldVec = this.modelPosAnimator.oldValue();
        Vec2 newVec = this.modelPosAnimator.newValue();
        float xOffset = this.modelPosAnimator.lerp(oldVec.f_82470_, newVec.f_82470_, System.currentTimeMillis());
        float yOffset = this.modelPosAnimator.lerp(oldVec.f_82471_, newVec.f_82471_, System.currentTimeMillis());
        posestack.m_85837_((double)((float)this.f_97735_ + xOffset), (double)((float)this.f_97736_ + yOffset), 50.0);
        float currentScale = this.scaleAnimator.lerp(this.scaleAnimator.oldValue().floatValue(), this.scaleAnimator.newValue().floatValue(), System.currentTimeMillis());
        posestack.m_85841_(currentScale, currentScale, -currentScale);
        float size = (float)renderEntity.m_20191_().m_82309_();
        float resizeScale = 1.0f / Math.max(size, 1.25f);
        posestack.m_85841_(resizeScale, resizeScale, resizeScale);
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        float rotationPeriod = 12.0f;
        float rotPitch = 195.0f;
        float rot = (float)(System.currentTimeMillis() % (long)((int)(rotationPeriod * 1000.0f))) * (360.0f / (rotationPeriod * 1000.0f));
        posestack.m_252781_(Axis.f_252529_.m_252977_(rotPitch));
        posestack.m_252781_(Axis.f_252436_.m_252977_(rot));
        entityrenderdispatcher.m_114468_(false);
        entityrenderdispatcher.m_114384_(renderEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0);
        guiGraphics.m_280262_();
        entityrenderdispatcher.m_114468_(true);
        posestack.m_85849_();
        Lighting.m_84931_();
        RenderSystem.disableScissor();
    }

    public void renderRecipeInfo(VehicleAssemblingRecipe recipe, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String key;
        EntityType entityType;
        CompoundTag tag;
        ItemStack stack = recipe.getResult().getResult();
        boolean renderItemName = true;
        if (stack.m_150930_((Item)ModItems.CONTAINER.get()) && (tag = BlockItem.m_186336_((ItemStack)stack)) != null && tag.m_128441_("EntityType") && (entityType = (EntityType)EntityType.m_20632_((String)(key = tag.m_128461_("EntityType"))).orElse(null)) != null) {
            this.renderContainerInfo(key, guiGraphics, mouseX, mouseY);
            renderItemName = false;
        }
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_85841_(0.75f, 0.75f, 1.0f);
        if (renderItemName) {
            RenderHelper.renderScrollingString(guiGraphics, this.f_96547_, (Component)Component.m_237119_().m_7220_(stack.m_41786_()).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.YELLOW), 0.75f, (int)((float)(this.f_97735_ + 122) / 0.75f), (int)((float)(this.f_97736_ + 119) / 0.75f), (int)((float)(this.f_97735_ + 198) / 0.75f), (int)((float)(this.f_97736_ + 130) / 0.75f), 0xFFFFFF);
        }
        MutableComponent modName = Component.m_264568_((String)("info." + recipe.m_6423_().m_135827_() + ".mod_id"), (String)recipe.m_6423_().m_135827_());
        MutableComponent modInfo = Component.m_237110_((String)"container.superbwarfare.mod_info", (Object[])new Object[]{modName.m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.AQUA)});
        RenderHelper.renderScrollingString(guiGraphics, this.f_96547_, (Component)modInfo, 0.75f, (int)((float)(this.f_97735_ + 122) / 0.75f), (int)((float)(this.f_97736_ + 167) / 0.75f), (int)((float)(this.f_97735_ + 198) / 0.75f), (int)((float)(this.f_97736_ + 178) / 0.75f), 0xFFFFFF);
        pose.m_85849_();
    }

    private void renderContainerInfo(String typeName, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack pose = guiGraphics.m_280168_();
        String key = ContainerBlock.getEntityTranslationKey(typeName);
        if (key == null) {
            return;
        }
        if (typeName.split(":").length < 2) {
            return;
        }
        MutableComponent info = Component.m_264568_((String)("info." + typeName.split(":")[0] + "." + typeName.split(":")[1]), (String)Component.m_237115_((String)"info.superbwarfare.no_info").getString());
        List infoComponents = this.f_96547_.m_92923_(FormattedText.m_130775_((String)info.getString()), 100);
        pose.m_85836_();
        pose.m_85841_(0.75f, 0.75f, 1.0f);
        MutableComponent hoverName = Component.m_237115_((String)key).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.YELLOW);
        RenderHelper.renderScrollingString(guiGraphics, this.f_96547_, (Component)hoverName, 0.75f, (int)((float)(this.f_97735_ + 122) / 0.75f), (int)((float)(this.f_97736_ + 119) / 0.75f), (int)((float)(this.f_97735_ + 198) / 0.75f), (int)((float)(this.f_97736_ + 130) / 0.75f), 0xFFFFFF);
        guiGraphics.m_280588_(this.f_97735_ + 120, this.f_97736_ + 129, this.f_97735_ + 198, this.f_97736_ + 165);
        for (int j = 0; j < infoComponents.size(); ++j) {
            FormattedCharSequence cachedComponent = j > 3 ? Component.m_237113_((String)"...").m_7532_() : (FormattedCharSequence)infoComponents.get(j);
            guiGraphics.m_280649_(this.f_96547_, cachedComponent, (int)((float)(this.f_97735_ + 122) / 0.75f), (int)(((float)(this.f_97736_ + 129) + (float)j * 7.5f) / 0.75f), 2896193, false);
        }
        guiGraphics.m_280618_();
        pose.m_85849_();
        if (mouseX >= this.f_97735_ + 120 && mouseX <= this.f_97735_ + 200 && mouseY >= this.f_97736_ + 117 && mouseY <= this.f_97736_ + 175) {
            guiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_(FormattedText.m_130775_((String)info.getString()), 200), mouseX, mouseY);
        }
    }

    @Nullable
    public VehicleAssemblingRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public List<IngredientArea> getIngredientAreas() {
        ArrayList<IngredientArea> areas = new ArrayList<IngredientArea>();
        if (this.currentRecipe != null) {
            List<VehicleAssemblingIngredient> inputs = this.currentRecipe.getInputs();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    int index = i * 4 + j;
                    if (index >= inputs.size()) {
                        return areas;
                    }
                    VehicleAssemblingIngredient input = inputs.get(index);
                    Ingredient ingredient = input.getIngredient();
                    ItemStack[] items = ingredient.m_43908_();
                    if (items.length == 0) continue;
                    int x = this.f_97735_ + 215 + j * 34;
                    int y = this.f_97736_ + 118 + i * 14;
                    areas.add(new IngredientArea(ingredient, x, y, 12.8, 12.8));
                }
            }
        }
        return areas;
    }

    public record IngredientArea(Ingredient ingredient, double x, double y, double width, double height) {
        public boolean contains(double mouseX, double mouseY) {
            return mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        }
    }
}

