/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.block.entity.ChargingStationBlockEntity;
import com.atsuishio.superbwarfare.menu.ChargingStationMenu;
import com.atsuishio.superbwarfare.network.message.send.ShowChargingRangeMessage;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ChargingStationScreen
extends AbstractContainerScreen<ChargingStationMenu> {
    private static final ResourceLocation TEXTURE = Mod.loc("textures/gui/charging_station.png");

    public ChargingStationScreen(ChargingStationMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        long fuelTick = ((ChargingStationMenu)this.f_97732_).getFuelTick();
        long maxFuelTick = ((ChargingStationMenu)this.f_97732_).getMaxFuelTick();
        long energy = ((ChargingStationMenu)this.f_97732_).getEnergy();
        if (maxFuelTick == 0L) {
            maxFuelTick = ChargingStationBlockEntity.DEFAULT_FUEL_TIME;
        }
        float fuelRate = (float)fuelTick / (float)maxFuelTick;
        pGuiGraphics.m_280218_(TEXTURE, i + 45, j + 51 - (int)(13.0f * fuelRate), 177, 14 - (int)(13.0f * fuelRate), 13, (int)(13.0f * fuelRate));
        float energyRate = (float)energy / (float)ChargingStationBlockEntity.MAX_ENERGY;
        pGuiGraphics.m_280218_(TEXTURE, i + 80, j + 70 - (int)(54.0f * energyRate), 177, 17, 16, (int)(54.0f * energyRate));
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_280072_(@NotNull GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        tooltip.add(Component.m_237110_((String)"des.superbwarfare.charging_station.energy", (Object[])new Object[]{((ChargingStationMenu)this.f_97732_).getEnergy(), ChargingStationBlockEntity.MAX_ENERGY}));
        if (pX - i >= 80 && pX - i <= 96 && pY - j >= 16 && pY - j <= 70) {
            pGuiGraphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), pX, pY);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 8;
        this.f_97729_ = 5;
        this.f_97730_ = 8;
        this.f_97731_ = 74;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_142416_((GuiEventListener)new ShowRangeButton(i, j));
    }

    @OnlyIn(value=Dist.CLIENT)
    class ShowRangeButton
    extends AbstractButton {
        protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            this.m_93666_((Component)(((ChargingStationMenu)ChargingStationScreen.this.f_97732_).showRange() ? Component.m_237115_((String)"container.superbwarfare.charging_station.hide_range") : Component.m_237115_((String)"container.superbwarfare.charging_station.show_range")));
            super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }

        public ShowRangeButton(int pX, int pY) {
            super(pX + 7, pY + 55, 33, 14, (Component)Component.m_237115_((String)"container.superbwarfare.charging_station.show_range"));
        }

        public void m_5691_() {
            Mod.PACKET_HANDLER.sendToServer((Object)new ShowChargingRangeMessage(!((ChargingStationMenu)ChargingStationScreen.this.f_97732_).showRange()));
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

