/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomCloudParticle
extends TextureSheetParticle {
    protected boolean cooldown;
    protected boolean light;
    private final SpriteSet spriteSet;

    protected CustomCloudParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet, float rCol, float gCol, float bCol, int life, float size, float gravity, boolean cooldown, boolean light) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.4f, 0.4f);
        this.f_107663_ *= size;
        this.f_107225_ = Math.max(1, life + (this.f_107223_.m_188503_(life) - (int)(0.1 * (double)life)));
        this.f_107226_ = gravity;
        this.f_107219_ = false;
        this.f_107215_ = vx * 0.01;
        this.f_107216_ = vy * 0.01;
        this.f_107217_ = vz * 0.01;
        this.m_108339_(spriteSet);
        this.f_107227_ = rCol;
        this.f_107228_ = gCol;
        this.f_107229_ = bCol;
        this.cooldown = cooldown;
        this.light = light;
    }

    public ParticleRenderType m_7556_() {
        return this.light ? ParticleRenderType.f_107432_ : ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.cooldown) {
            this.f_107227_ *= 0.985f;
            this.f_107228_ *= 0.985f;
            this.f_107229_ *= 0.985f;
        }
        if (!this.f_107220_) {
            this.m_108337_(this.spriteSet.m_5819_(Math.min(this.f_107224_ / 8 + 1, 8), 8));
        }
        if (this.f_107224_++ < this.f_107225_ && !(this.f_107230_ <= 0.0f)) {
            this.f_107230_ = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        } else {
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<CustomCloudOption> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(CustomCloudOption pType, ClientLevel pLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CustomCloudParticle(pLevel, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, pType.getRed(), pType.getGreen(), pType.getBlue(), pType.getLife(), pType.getSize(), pType.getGravity(), pType.getCooldown(), pType.getLight());
        }
    }
}

