/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class IglaHudOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_igla_hud";
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/igla_9k38/frame.png");
    private static final ResourceLocation PART_1 = Mod.loc("textures/screens/igla_9k38/part_1.png");
    private static final ResourceLocation PART_2 = Mod.loc("textures/screens/igla_9k38/part_2.png");
    private static final ResourceLocation PART_3 = Mod.loc("textures/screens/igla_9k38/part_3.png");
    private static final ResourceLocation PART_4 = Mod.loc("textures/screens/igla_9k38/part_4.png");
    private static final ResourceLocation HOLD = Mod.loc("textures/screens/igla_9k38/hold.png");
    private static final ResourceLocation SHOOT = Mod.loc("textures/screens/igla_9k38/shoot.png");
    private static float scopeScale = 1.0f;
    private static float lerpSeeking = 1.0f;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        ArmedVehicleEntity iArmedVehicle;
        LocalPlayer player = gui.getMinecraft().f_91074_;
        PoseStack poseStack = guiGraphics.m_280168_();
        Camera camera = gui.getMinecraft().f_91063_.m_109153_();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (ClientEventHandler.isEditing) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).banHand((LivingEntity)player)) {
            return;
        }
        if (stack.m_41720_() == ModItems.IGLA.get() && ClientEventHandler.zoomPos > 0.83 && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && ClientEventHandler.zoom) {
            GunData data = GunData.from(stack);
            poseStack.m_85836_();
            float deltaFrame = Minecraft.m_91087_().m_91297_();
            float moveX = (float)(-32.0 * ClientEventHandler.turnRot[1] - (double)(player.m_20142_() ? 100 : 67) * ClientEventHandler.movePosX + 3.0 * ClientEventHandler.cameraRot[2]);
            float moveY = (float)(-32.0 * ClientEventHandler.turnRot[0] + (double)(100.0f * (float)ClientEventHandler.velocityY) - (double)(player.m_20142_() ? 100 : 67) * ClientEventHandler.movePosY - 12.0 * ClientEventHandler.firePos + 3.0 * ClientEventHandler.cameraRot[1]);
            scopeScale = (float)Mth.m_14139_((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
            float f = Math.min(screenWidth, screenHeight);
            float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * scopeScale;
            float i = Mth.m_14143_((float)(f * f1));
            float j = Mth.m_14143_((float)(f * f1));
            Vec3 pCross = VectorUtil.worldToScreen(camera.m_90583_().m_82549_(new Vec3(camera.m_253058_())));
            float x0 = (float)pCross.f_82479_ + 4.0f * moveX;
            float y0 = (float)pCross.f_82480_ + 4.0f * moveY;
            BlockPos blockPos = player.m_20183_();
            int combinedLightLevel = player.m_9236_().m_46803_(blockPos);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)((float)combinedLightLevel / 15.0f), (float)((float)combinedLightLevel / 15.0f), (float)((float)combinedLightLevel / 15.0f), (float)1.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/igla_9k38/igla_scope.png"), x0 - 1.5f * i, y0 - 1.5f * j, 0.0f, 0.0f, 3.0f * i, 3.0f * j, 3.0f * i, 3.0f * j);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Entity targetEntity = EntityFindUtil.findEntity(player.m_9236_(), stack.m_41784_().m_128461_("TargetEntity"));
            int seekingTime = stack.m_41784_().m_128451_("SeekTime");
            lerpSeeking = Mth.m_14179_((float)partialTick, (float)lerpSeeking, (float)((float)Mth.m_14045_((int)(30 - stack.m_41784_().m_128451_("SeekTime")), (int)0, (int)30) * 0.6f));
            if (targetEntity != null) {
                Vec3 pos = VectorTool.lerpGetEntityBoundingBoxCenter(targetEntity, partialTick);
                Vec3 point = VectorUtil.worldToScreen(pos);
                float x = (float)point.f_82479_;
                float y = (float)point.f_82480_;
                poseStack.m_85836_();
                poseStack.m_252880_(x, y, 0.0f);
                RenderHelper.blit(poseStack, FRAME, -12.0f, -12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                RenderHelper.blit(poseStack, PART_1, -12.0f - lerpSeeking, -12.0f - lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                RenderHelper.blit(poseStack, PART_2, -12.0f + lerpSeeking, -12.0f - lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                RenderHelper.blit(poseStack, PART_3, -12.0f - lerpSeeking, -12.0f + lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                RenderHelper.blit(poseStack, PART_4, -12.0f + lerpSeeking, -12.0f + lerpSeeking, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                if (seekingTime >= 30 && data.ammo.get() > 0) {
                    RenderHelper.blit(poseStack, SHOOT, -12.0f, -26.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                } else {
                    RenderHelper.blit(poseStack, HOLD, -12.0f, -26.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                }
                poseStack.m_85836_();
                String range = FormatTool.format0D(player.m_20270_(targetEntity));
                int width = Minecraft.m_91087_().f_91062_.m_92895_(range);
                poseStack.m_85841_(0.8f, 0.8f, 1.0f);
                poseStack.m_252880_(0.1f, 0.0f, 0.0f);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)range), (int)(-((float)width) / 2.0f), 14, 16766646, false);
                poseStack.m_85849_();
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        } else {
            scopeScale = 1.0f;
        }
    }
}

