/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class HandsomeFrameOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_handsome_frame";
    private static final ResourceLocation FRAME = Mod.loc("textures/screens/frame/frame.png");
    private static final ResourceLocation FRAME_WEAK = Mod.loc("textures/screens/frame/frame_weak.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/screens/frame/frame_target.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/screens/frame/frame_lock.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        ArmedVehicleEntity iArmedVehicle;
        LocalPlayer player = gui.getMinecraft().f_91074_;
        PoseStack poseStack = guiGraphics.m_280168_();
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (ClientEventHandler.isEditing) {
            return;
        }
        Entity entity = player.m_20202_();
        if (entity instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).banHand((LivingEntity)player)) {
            return;
        }
        if (stack.m_41720_() instanceof GunItem && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            short level = GunData.from((ItemStack)stack).perk.getLevel(ModPerks.INTELLIGENT_CHIP);
            if (level == 0) {
                return;
            }
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            List<Entity> allEntities = SeekTool.seekLivingEntitiesThroughWall((Entity)player, player.m_9236_(), 32 + 8 * (level - 1), 30.0);
            List<Entity> visibleEntities = SeekTool.seekLivingEntities((Entity)player, player.m_9236_(), 32 + 8 * (level - 1), 30.0);
            Entity naerestEntity = SeekTool.seekLivingEntity((Entity)player, player.m_9236_(), 32 + 8 * (level - 1), 30.0);
            Entity targetEntity = ClientEventHandler.entity;
            for (Entity e : allEntities) {
                Vec3 pos = new Vec3(Mth.m_14139_((double)partialTick, (double)e.f_19854_, (double)e.m_20185_()), Mth.m_14139_((double)partialTick, (double)(e.f_19855_ + (double)e.m_20192_()), (double)e.m_20188_()), Mth.m_14139_((double)partialTick, (double)e.f_19856_, (double)e.m_20189_()));
                Vec3 point = VectorUtil.worldToScreen(pos);
                boolean lockOn = e == targetEntity;
                boolean isNearestEntity = e == naerestEntity;
                poseStack.m_85836_();
                float x = (float)point.f_82479_;
                float y = (float)point.f_82480_;
                boolean canBeSeen = visibleEntities.contains(e);
                ResourceLocation icon = lockOn ? FRAME_LOCK : (canBeSeen ? (isNearestEntity ? FRAME_TARGET : FRAME) : FRAME_WEAK);
                RenderHelper.blit(poseStack, icon, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                poseStack.m_85849_();
            }
        }
    }
}

