/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class GrenadeLauncherOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_grenade_launcher";
    private static float scopeScale = 1.0f;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        ArmedVehicleEntity iArmedVehicle;
        Entity entity;
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player != null && ClientEventHandler.isEditing) {
            return;
        }
        if (player != null && (entity = player.m_20202_()) instanceof ArmedVehicleEntity && (iArmedVehicle = (ArmedVehicleEntity)entity).banHand((LivingEntity)player)) {
            return;
        }
        if (!GrenadeLauncherOverlay.shouldRenderCrossHair((Player)player)) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (data.get(GunProp.PROJECTILE_AMOUNT) > 1) {
            double spread = ClientEventHandler.gunSpread + 1.0 * ClientEventHandler.firePos;
            float deltaFrame = Minecraft.m_91087_().m_91297_();
            float moveX = 0.0f;
            float moveY = 0.0f;
            if (((Boolean)DisplayConfig.FLOAT_CROSS_HAIR.get()).booleanValue() && player.m_20202_() == null) {
                moveX = (float)(-6.0 * ClientEventHandler.turnRot[1] - (double)(player.m_20142_() ? 10 : 6) * ClientEventHandler.movePosX);
                moveY = (float)(-6.0 * ClientEventHandler.turnRot[0] + (double)(6.0f * (float)ClientEventHandler.velocityY) - (double)(player.m_20142_() ? 10 : 6) * ClientEventHandler.movePosY - 0.25 * ClientEventHandler.firePos);
            }
            scopeScale = (float)Mth.m_14139_((double)(0.5f * deltaFrame), (double)scopeScale, (double)(1.0 + 1.5 * spread));
            float minLength = Math.min(screenWidth, screenHeight);
            float scaledMinLength = Math.min((float)screenWidth / minLength, (float)screenHeight / minLength) * 0.012f * scopeScale;
            float finLength = Mth.m_14143_((float)(minLength * scaledMinLength));
            float finPosX = ((float)screenWidth - finLength) / 2.0f + moveX;
            float finPosY = ((float)screenHeight - finLength) / 2.0f + moveY;
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/point.png"), (float)screenWidth / 2.0f - 7.5f + moveX, (float)screenHeight / 2.0f - 7.5f + moveY, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/shotgun_hud.png"), finPosX, finPosY, 0.0f, 0.0f, finLength, finLength, finLength, finLength);
        } else {
            guiGraphics.m_280163_(Mod.loc("textures/screens/rex.png"), screenWidth / 2 - 16, screenHeight / 2 - 16, 0.0f, 0.0f, 32, 32, 32, 32);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_85849_();
    }

    private static boolean shouldRenderCrossHair(Player player) {
        if (player == null) {
            return false;
        }
        return !player.m_5833_() && player.m_21205_().m_204117_(ModTags.Items.LAUNCHER_GRENADE) && (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || player.m_20159_() && player.m_20202_() instanceof CannonEntity) && !ClientEventHandler.zoom;
    }
}

