/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.item;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.model.item.CustomGunModel;
import com.atsuishio.superbwarfare.client.overlay.CrossHairOverlay;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.machinegun.MinigunItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;

public class MinigunItemModel
extends CustomGunModel<MinigunItem> {
    private static float rotZ = 0.0f;

    public ResourceLocation getAnimationResource(MinigunItem animatable) {
        return Mod.loc("animations/minigun.animation.json");
    }

    public ResourceLocation getModelResource(MinigunItem animatable) {
        return Mod.loc("geo/minigun.geo.json");
    }

    public ResourceLocation getTextureResource(MinigunItem animatable) {
        return Mod.loc("textures/item/minigun.png");
    }

    @Override
    public ResourceLocation getLODModelResource(MinigunItem animatable) {
        return Mod.loc("geo/lod/minigun.geo.json");
    }

    @Override
    public ResourceLocation getLODTextureResource(MinigunItem animatable) {
        return Mod.loc("textures/item/lod/minigun.png");
    }

    public void setCustomAnimations(MinigunItem animatable, long instanceId, AnimationState<MinigunItem> animationState) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (this.shouldCancelRender(stack, animationState)) {
            return;
        }
        CoreGeoBone gun = this.getAnimationProcessor().getBone("barrel");
        CoreGeoBone shen = this.getAnimationProcessor().getBone("shen");
        float times = 0.6f * (float)Math.min((double)Minecraft.m_91087_().m_91297_(), 0.8);
        double fpz = ClientEventHandler.firePosZ * 13.0 * (double)times;
        double fp = ClientEventHandler.firePos;
        double fr = ClientEventHandler.fireRot;
        GunData data = GunData.from(stack);
        int rpm = data.get(GunProp.RPM);
        float heat = (float)data.heat.get();
        for (int i = 1; i <= 6; ++i) {
            CoreGeoBone bone = this.getAnimationProcessor().getBone("barrel" + i + "_illuminated");
            bone.setScaleZ(heat / 2.0f);
        }
        gun.setRotZ(rotZ += times * -0.14f * ((float)rpm / 1200.0f) * (float)ClientEventHandler.shootDelay);
        ClientEventHandler.handleShootAnimation(shen, 1.0f, -0.4f, 1.2f, 1.3f, 1.0f, 1.0f, 0.0f, 0.7f);
        CrossHairOverlay.gunRot = shen.getRotZ();
        ClientEventHandler.gunRootMove(this.getAnimationProcessor(), 7.0f, 1.0f, 3.0f, false);
        CoreGeoBone camera = this.getAnimationProcessor().getBone("camera");
        ClientEventHandler.handleReloadShake(57.295776f * camera.getRotX(), 57.295776f * camera.getRotY(), 57.295776f * camera.getRotZ());
    }
}

