/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.model.entity;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.vehicle.AnnihilatorEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class AnnihilatorModel
extends GeoModel<AnnihilatorEntity> {
    public ResourceLocation getAnimationResource(AnnihilatorEntity entity) {
        return Mod.loc("animations/annihilator.animation.json");
    }

    public ResourceLocation getModelResource(AnnihilatorEntity entity) {
        if (RenderHelper.isInGui()) {
            return Mod.loc("geo/annihilator.geo.json");
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int distance = 0;
        if (player != null) {
            distance = (int)player.m_20182_().m_82554_(entity.m_20182_());
        }
        if (distance < 64) {
            return Mod.loc("geo/annihilator.geo.json");
        }
        return Mod.loc("geo/vehicle_lod/annihilator.lod1.geo.json");
    }

    public ResourceLocation getTextureResource(AnnihilatorEntity entity) {
        return Mod.loc("textures/entity/annihilator.png");
    }

    public void setCustomAnimations(AnnihilatorEntity animatable, long instanceId, AnimationState<AnnihilatorEntity> animationState) {
        CoreGeoBone laserLeft = this.getAnimationProcessor().getBone("laser1");
        CoreGeoBone laserMiddle = this.getAnimationProcessor().getBone("laser2");
        CoreGeoBone laserRight = this.getAnimationProcessor().getBone("laser3");
        laserLeft.setScaleZ(((Float)animatable.m_20088_().m_135370_(AnnihilatorEntity.LASER_LEFT_LENGTH)).floatValue() + 0.5f);
        laserMiddle.setScaleZ(((Float)animatable.m_20088_().m_135370_(AnnihilatorEntity.LASER_MIDDLE_LENGTH)).floatValue() + 0.5f);
        laserRight.setScaleZ(((Float)animatable.m_20088_().m_135370_(AnnihilatorEntity.LASER_RIGHT_LENGTH)).floatValue() + 0.5f);
        CoreGeoBone ledGreen = this.getAnimationProcessor().getBone("ledgreen");
        CoreGeoBone ledGreen2 = this.getAnimationProcessor().getBone("ledgreen2");
        CoreGeoBone ledGreen3 = this.getAnimationProcessor().getBone("ledgreen3");
        CoreGeoBone ledGreen4 = this.getAnimationProcessor().getBone("ledgreen4");
        CoreGeoBone ledGreen5 = this.getAnimationProcessor().getBone("ledgreen5");
        CoreGeoBone ledRed = this.getAnimationProcessor().getBone("ledred");
        CoreGeoBone ledRed2 = this.getAnimationProcessor().getBone("ledred2");
        CoreGeoBone ledRed3 = this.getAnimationProcessor().getBone("ledred3");
        CoreGeoBone ledRed4 = this.getAnimationProcessor().getBone("ledred4");
        CoreGeoBone ledRed5 = this.getAnimationProcessor().getBone("ledred5");
        float coolDown = ((Integer)animatable.m_20088_().m_135370_(AnnihilatorEntity.COOL_DOWN)).intValue();
        boolean cantShoot = animatable.getEnergy() < (Integer)VehicleConfig.ANNIHILATOR_SHOOT_COST.get();
        ledGreen.setHidden(coolDown > 80.0f || cantShoot);
        ledGreen2.setHidden(coolDown > 60.0f || cantShoot);
        ledGreen3.setHidden(coolDown > 40.0f || cantShoot);
        ledGreen4.setHidden(coolDown > 20.0f || cantShoot);
        ledGreen5.setHidden(coolDown > 0.0f || cantShoot);
        ledRed.setHidden(!ledGreen.isHidden());
        ledRed2.setHidden(!ledGreen2.isHidden());
        ledRed3.setHidden(!ledGreen3.isHidden());
        ledRed4.setHidden(!ledGreen4.isHidden());
        ledRed5.setHidden(!ledGreen5.isHidden());
    }
}

