/*
 * Decompiled with CFR 0.152.
 */
package net.fullfud.skinloaderf.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fullfud.skinloaderf.SkinLoaderF;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class SkinCache {
    private static final String URL_TEMPLATE = "https://launcher.frontcivil.fun/textures/skins/%s.png";
    private static final long REVALIDATE_EVERY_MS = 5000L;
    private static final SkinCache INSTANCE = new SkinCache();
    private final HttpClient http = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    private final Map<String, Entry> entries = new ConcurrentHashMap<String, Entry>();
    private volatile boolean initialized = false;
    private Path cacheDir;

    public static void init() {
        INSTANCE.ensureInit();
    }

    public static SkinCache get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInit() {
        if (this.initialized) {
            return;
        }
        SkinCache skinCache = this;
        synchronized (skinCache) {
            if (this.initialized) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            Path gameDir = mc.f_91069_.toPath();
            this.cacheDir = gameDir.resolve("skinloaderf").resolve("skins");
            try {
                Files.createDirectories(this.cacheDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                SkinLoaderF.LOGGER.error("Failed to create cache dir for skins", (Throwable)e);
            }
            this.initialized = true;
        }
    }

    public ResourceLocation getSkinIfReady(String playerName) {
        this.ensureInit();
        if (playerName == null || playerName.isEmpty()) {
            return null;
        }
        String key = SkinCache.keyFor(playerName);
        Entry e = this.entries.computeIfAbsent(key, k -> new Entry(this.cacheDir.resolve(k + ".png"), this.cacheDir.resolve(k + ".meta")));
        this.maybeRequestOrRevalidate(playerName, key, e);
        return e.rl;
    }

    public void ensureRequested(String playerName) {
        this.ensureInit();
        if (playerName == null || playerName.isEmpty()) {
            return;
        }
        String key = SkinCache.keyFor(playerName);
        Entry e = this.entries.computeIfAbsent(key, k -> new Entry(this.cacheDir.resolve(k + ".png"), this.cacheDir.resolve(k + ".meta")));
        this.maybeRequestOrRevalidate(playerName, key, e);
    }

    private void maybeRequestOrRevalidate(String originalName, String key, Entry e) {
        boolean needRevalidate;
        long now = System.currentTimeMillis();
        if (e.loading.get()) {
            return;
        }
        boolean needFirstLoad = e.rl == null && !e.loading.get();
        boolean bl = needRevalidate = now - e.lastChecked >= 5000L;
        if (needFirstLoad || needRevalidate) {
            e.loading.set(true);
            e.lastChecked = now;
            Util.m_183991_().execute(() -> {
                try {
                    boolean changed = this.downloadOrValidate(originalName, e);
                    if (Files.exists(e.file, new LinkOption[0])) {
                        this.uploadToTexture(key, e);
                        if (changed) {
                            SkinLoaderF.LOGGER.info("Updated skin for {} (key={})", (Object)originalName, (Object)key);
                        }
                    }
                }
                catch (Exception ex) {
                    SkinLoaderF.LOGGER.warn("Skin load failed for {}: {}", (Object)originalName, (Object)ex.toString());
                }
                finally {
                    e.loading.set(false);
                }
            });
        }
    }

    private boolean downloadOrValidate(String originalName, Entry e) throws Exception {
        String candidate1 = originalName.trim();
        String candidate2 = candidate1.toLowerCase(Locale.ROOT);
        Integer code1 = this.tryFetch(candidate1, e);
        if (code1 != null) {
            if (code1 == 200) {
                SkinLoaderF.LOGGER.info("Skin 200 OK for {} (exact case)", (Object)candidate1);
                return true;
            }
            if (code1 == 304) {
                return false;
            }
            if (code1 == 404) {
                SkinLoaderF.LOGGER.info("Skin 404 Not Found for {} (exact case)", (Object)candidate1);
                if (!candidate1.equals(candidate2)) {
                    Integer code2 = this.tryFetch(candidate2, e);
                    if (code2 != null) {
                        if (code2 == 200) {
                            SkinLoaderF.LOGGER.info("Skin 200 OK for {} (fallback lower-case {})", (Object)candidate1, (Object)candidate2);
                            return true;
                        }
                        if (code2 == 304) {
                            return false;
                        }
                        if (code2 == 404) {
                            SkinLoaderF.LOGGER.info("Skin 404 Not Found for {} and {}", (Object)candidate1, (Object)candidate2);
                            e.absent = true;
                            return false;
                        }
                        SkinLoaderF.LOGGER.debug("Unexpected HTTP {} for fallback {}", (Object)code2, (Object)candidate2);
                        return false;
                    }
                } else {
                    e.absent = true;
                }
                return false;
            }
            SkinLoaderF.LOGGER.debug("Unexpected HTTP {} for {}", (Object)code1, (Object)candidate1);
            return false;
        }
        return false;
    }

    private Integer tryFetch(String urlName, Entry e) {
        try {
            HttpResponse<byte[]> resp;
            int code;
            String encoded = URLEncoder.encode(urlName, StandardCharsets.UTF_8);
            String url = String.format(Locale.ROOT, URL_TEMPLATE, encoded);
            HttpRequest.Builder b = HttpRequest.newBuilder().uri(URI.create(url)).header("Accept", "image/png").header("User-Agent", "skinloaderf/1.0 (Forge 1.20.1)").GET();
            if (e.etag != null) {
                b.header("If-None-Match", e.etag);
            }
            if (e.lastModified != null) {
                b.header("If-Modified-Since", e.lastModified);
            }
            if ((code = (resp = this.http.send(b.build(), HttpResponse.BodyHandlers.ofByteArray())).statusCode()) == 200) {
                byte[] body = resp.body();
                if (body != null && body.length > 0) {
                    Files.createDirectories(e.file.getParent(), new FileAttribute[0]);
                    Path tmp = e.file.resolveSibling(e.file.getFileName().toString() + ".tmp");
                    Files.write(tmp, body, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Files.move(tmp, e.file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    e.etag = SkinCache.header(resp, "etag").orElse(null);
                    e.lastModified = SkinCache.header(resp, "last-modified").orElse(null);
                    e.absent = false;
                    e.saveMeta();
                }
            } else if (code != 304 && code == 404) {
                e.absent = true;
            }
            return code;
        }
        catch (Exception ex) {
            SkinLoaderF.LOGGER.warn("HTTP error for {}: {}", (Object)urlName, (Object)ex.toString());
            return null;
        }
    }

    private void uploadToTexture(String key, Entry e) {
        if (!Files.exists(e.file, new LinkOption[0])) {
            return;
        }
        try (InputStream in = Files.newInputStream(e.file, new OpenOption[0]);){
            NativeImage img = NativeImage.m_85058_((InputStream)in);
            if (img == null) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            mc.execute(() -> {
                try {
                    if (e.dyn != null) {
                        try {
                            e.dyn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    e.dyn = new DynamicTexture(img);
                    if (e.rl == null) {
                        e.rl = new ResourceLocation("skinloaderf", "skins/" + key);
                    }
                    mc.m_91097_().m_118495_(e.rl, (AbstractTexture)e.dyn);
                }
                catch (Exception ex) {
                    SkinLoaderF.LOGGER.warn("Failed to register dynamic texture for {}: {}", (Object)key, (Object)ex.toString());
                }
            });
        }
        catch (IOException ex) {
            SkinLoaderF.LOGGER.warn("Failed to read image for {}: {}", (Object)key, (Object)ex.toString());
        }
    }

    private static Optional<String> header(HttpResponse<?> resp, String name) {
        return resp.headers().firstValue(name);
    }

    private static String keyFor(String name) {
        String s = name == null ? "" : name.trim();
        s = s.replaceAll("[^a-zA-Z0-9_\\-\\.]", "_").toLowerCase(Locale.ROOT);
        return s;
    }

    private static class Entry {
        final Path file;
        final Path meta;
        volatile ResourceLocation rl;
        volatile DynamicTexture dyn;
        volatile String etag;
        volatile String lastModified;
        volatile boolean absent = false;
        volatile long lastChecked = 0L;
        final AtomicBoolean loading = new AtomicBoolean(false);

        Entry(Path file, Path meta) {
            this.file = Objects.requireNonNull(file);
            this.meta = Objects.requireNonNull(meta);
            this.loadMeta();
        }

        void loadMeta() {
            if (!Files.exists(this.meta, new LinkOption[0])) {
                return;
            }
            try {
                for (String line : Files.readAllLines(this.meta, StandardCharsets.UTF_8)) {
                    int i = line.indexOf(61);
                    if (i <= 0) continue;
                    String k = line.substring(0, i).trim();
                    String v = line.substring(i + 1).trim();
                    if (k.equalsIgnoreCase("etag")) {
                        this.etag = v;
                    }
                    if (!k.equalsIgnoreCase("lastModified")) continue;
                    this.lastModified = v;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void saveMeta() {
            try {
                StringBuilder sb = new StringBuilder();
                if (this.etag != null) {
                    sb.append("etag=").append(this.etag).append('\n');
                }
                if (this.lastModified != null) {
                    sb.append("lastModified=").append(this.lastModified).append('\n');
                }
                Files.writeString(this.meta, (CharSequence)sb.toString(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

