/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Auricular;
import com.codinglitch.simpleradio.api.central.Frequencing;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.Listening;
import com.codinglitch.simpleradio.api.central.Receiving;
import com.codinglitch.simpleradio.api.central.Socket;
import com.codinglitch.simpleradio.api.central.Speaking;
import com.codinglitch.simpleradio.api.central.Transmitting;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundActivityPacket;
import com.codinglitch.simpleradio.core.registry.entities.Wire;
import com.codinglitch.simpleradio.platform.Services;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioSource;
import com.codinglitch.simpleradio.radio.RadioSpeaker;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RadioRouter
implements Socket {
    public ArrayList<Wire> wires = new ArrayList();
    public List<RadioRouter> routers = new ArrayList<RadioRouter>();
    public Function<RadioSource, Boolean> routerAcceptor;
    public BiPredicate<RadioSource, RadioRouter> routeCriteria;
    public Predicate<RadioSource> acceptCriteria;
    public boolean active = true;
    public boolean distributes = false;
    public boolean valid = true;
    public short identifier;
    public UUID reference;
    public Entity owner;
    public WorldlyPosition location;
    public Vector3f oldPosition = new Vector3f();
    public Vector3f velocity = new Vector3f();
    public float activity = 0.0f;
    public int activityTime = 0;
    public float compiledActivity = 0.0f;
    public int compiledSamples = 0;
    public Class<?> link;
    public Quaternionf rotation = null;
    public Vec3 connectionOffset = Vec3.f_82478_;

    public RadioRouter(UUID reference) {
        this.reference = reference;
    }

    public RadioRouter() {
        this(UUID.randomUUID());
    }

    public RadioRouter(WorldlyPosition location) {
        this(location, UUID.randomUUID());
    }

    public RadioRouter(WorldlyPosition location, UUID reference) {
        this(reference);
        this.location = location;
    }

    @Nullable
    public static RadioReceiver getRouterFromReceivers(UUID reference) {
        for (Frequency frequency : Frequency.getFrequencies()) {
            RadioReceiver receiver = frequency.getReceiver(reference);
            if (receiver == null) continue;
            return receiver;
        }
        return null;
    }

    @Nullable
    public static RadioTransmitter getRouterFromTransmitters(UUID reference) {
        for (Frequency frequency : Frequency.getFrequencies()) {
            RadioTransmitter transmitter = frequency.getTransmitter(reference);
            if (transmitter == null) continue;
            return transmitter;
        }
        return null;
    }

    @Override
    public RadioRouter getRouter() {
        return this;
    }

    @Override
    public UUID getReference() {
        return this.reference;
    }

    @Override
    public short getIdentifier() {
        return this.identifier;
    }

    public ArrayList<Wire> getWires() {
        return this.wires;
    }

    public void allowDistribution() {
        this.distributes = true;
    }

    @Nullable
    public Frequency getFrequency() {
        return null;
    }

    public double distanceTo(RadioRouter other) {
        return this.getLocation().distance(other.getLocation());
    }

    public Vec3 getConnectionPosition() {
        Vector3f translatedOffset = this.rotation == null ? this.connectionOffset.m_252839_() : this.rotation.transform(this.connectionOffset.m_252839_());
        return new Vec3(this.getLocation().position()).m_82520_((double)translatedOffset.x, (double)translatedOffset.y, (double)translatedOffset.z);
    }

    public WorldlyPosition getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.owner != null) {
            return new WorldlyPosition((float)this.owner.m_20185_(), (float)this.owner.m_20186_(), (float)this.owner.m_20189_(), this.owner.m_9236_());
        }
        return null;
    }

    public RadioRouter tryAddRouter(RadioRouter router) {
        RadioRouter existingRouter = this.getRouter(router.reference);
        if (existingRouter != null) {
            return existingRouter;
        }
        this.routers.add(router);
        return router;
    }

    public RadioRouter getRouter(UUID id) {
        return this.routers.stream().filter(router -> router.reference.equals(id)).findFirst().orElse(null);
    }

    public void updateLocation(WorldlyPosition location) {
    }

    public void updateRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void tick(int tickCount) {
        if (this.location != null) {
            this.updateRotation(Services.COMPAT.modifyRotation(this.location, this.rotation));
            this.updateLocation(Services.COMPAT.modifyPosition(this.location));
            Vector3f currentPosition = this.location.position();
            if (currentPosition != this.oldPosition) {
                currentPosition.sub((Vector3fc)this.oldPosition, this.velocity);
            } else {
                this.velocity.set(0.0f);
            }
            this.oldPosition.set((Vector3fc)currentPosition);
        } else if (this.owner != null) {
            this.updateLocation(WorldlyPosition.of(this.owner.m_20182_().m_252839_(), this.owner.m_9236_()));
        }
        if (!this.active) {
            this.activity = 0.0f;
            this.activityTime = -1;
            this.compiledSamples = 0;
            this.compiledActivity = 0.0f;
        } else if (this.activityTime > 0) {
            if (--this.activityTime == 0) {
                this.activity = 0.0f;
            }
        } else if (this.activityTime == 0) {
            this.activityTime = -1;
        }
    }

    public void accept(RadioSource source) {
        if (!this.active) {
            return;
        }
        if (this.acceptCriteria != null && !this.acceptCriteria.test(source)) {
            return;
        }
        this.route(source);
    }

    public RadioSource prepareSource(RadioSource source, RadioRouter destination) {
        if (this.getLocation().equals(destination.getLocation())) {
            return source;
        }
        source.travel(this, destination, this.getFrequency());
        return source;
    }

    public boolean shouldRouteTo(RadioSource source, RadioRouter destination) {
        return true;
    }

    public void route(RadioSource source, @Nullable Predicate<RadioRouter> criteria) {
        if (!this.active) {
            return;
        }
        if (!source.isValid()) {
            CommonSimpleRadio.warn("Invalid source; discarded", new Object[0]);
            return;
        }
        if (this.routerAcceptor != null && this.routerAcceptor.apply(source).booleanValue()) {
            source = source.copy();
        }
        if (this.distributes && this.distribute(source)) {
            source = source.copy();
        }
        for (int i = 0; i < this.routers.size(); ++i) {
            RadioRouter router = this.routers.get(i);
            if (criteria != null && !criteria.test(router) || !this.shouldRouteTo(source, router) || this.routeCriteria != null && !this.routeCriteria.test(source, router)) continue;
            if (source.willShort(router)) {
                router.shortCircuit();
                continue;
            }
            RadioSource oldSource = source = this.prepareSource(source, router);
            if (i < this.routers.size() - 1) {
                source = source.copy();
            }
            router.accept(oldSource);
        }
    }

    public void route(RadioSource source) {
        this.route(source, null);
    }

    public int getRedstoneMappedActivity() {
        return (int)Math.clamp((float)0.0f, (float)15.0f, (float)Math.round((double)((double)this.activity / SimpleRadioLibrary.SERVER_CONFIG.router.activityRedstoneFactor)));
    }

    public void compileActivity(RadioSource source) {
        if (!this.active) {
            return;
        }
        if (source.data == null) {
            this.activity = source.activity;
            this.compiledActivity = 0.0f;
            this.compiledSamples = 0;
        } else {
            this.compiledActivity += source.activity;
            if (this.compiledSamples++ >= SimpleRadioLibrary.SERVER_CONFIG.router.compileAmount) {
                this.activity = Math.sqrt((float)this.compiledActivity);
                this.compiledActivity = 0.0f;
                this.compiledSamples = 0;
            }
        }
        if (this.activityTime < SimpleRadioLibrary.SERVER_CONFIG.router.activityForgiveness) {
            this.activityTime = SimpleRadioLibrary.SERVER_CONFIG.router.activityTime;
            this.informActivity();
        }
    }

    public void informActivity() {
        WorldlyPosition location = this.getLocation();
        if (!location.isClientSide()) {
            for (Player player : location.level.m_6907_()) {
                if (!(location.position().distance((float)player.m_20185_(), (float)player.m_20186_(), (float)player.m_20189_()) <= 100.0f)) continue;
                Services.NETWORKING.sendToPlayer((ServerPlayer)player, new ClientboundActivityPacket(this.activity, this.getIdentifier()));
            }
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean validate() {
        if (!this.valid) {
            return false;
        }
        if (this.owner == null) {
            if (this.location == null) {
                this.invalidate();
                return false;
            }
            boolean flag = true;
            if (this instanceof RadioSpeaker) {
                flag = Auricular.validateLocation(this.location, this.link != null ? this.link : Speaking.class, this.reference);
            } else if (this instanceof RadioListener) {
                flag = Auricular.validateLocation(this.location, this.link != null ? this.link : Listening.class, this.reference);
            } else if (this instanceof RadioReceiver) {
                flag = Frequencing.validateLocation(this.location, this.link != null ? this.link : Receiving.class, this.reference, null);
            } else if (this instanceof RadioTransmitter) {
                flag = Frequencing.validateLocation(this.location, this.link != null ? this.link : Transmitting.class, this.reference, null);
            } else {
                boolean bl = flag = this.link != null && RadioManager.verifyLocationCollection(this.location, this.link);
            }
            if (!flag) {
                this.invalidate();
                return false;
            }
        } else {
            boolean isValid = RadioManager.verifyEntityCollection(this.owner, stack -> {
                if (stack.m_41619_()) {
                    return false;
                }
                if (!stack.m_41782_()) {
                    return false;
                }
                CompoundTag tag = stack.m_41783_();
                if (!tag.m_128441_("reference")) {
                    return false;
                }
                return tag.m_128342_("reference").equals(this.reference);
            });
            if (!isValid) {
                this.invalidate();
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getIdentifier() + "]" + this.getLocation().toString();
    }

    public static class Compiled<E>
    extends LinkedList<E> {
        @Override
        public boolean add(E value) {
            super.add(value);
            while (this.size() > 20) {
                super.remove();
            }
            return true;
        }
    }
}

