/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSource;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.world.entity.Entity;

public class RadioListener
extends RadioRouter {
    private UnaryOperator<RadioSource> dataTransformer;
    private final Map<UUID, OpusDecoder> decoders;
    public float range = 8.0f;
    public long lastHeader = 0L;
    public byte[] compiledData = new byte[0];

    protected RadioListener(UUID reference) {
        super(reference);
        this.decoders = new HashMap<UUID, OpusDecoder>();
    }

    protected RadioListener() {
        this(UUID.randomUUID());
    }

    public RadioListener(Entity owner) {
        this(owner, UUID.randomUUID());
    }

    public RadioListener(Entity owner, UUID uuid) {
        this(uuid);
        this.owner = owner;
        boolean isClient = owner.m_9236_().m_5776_();
        RadioManager.registerRouterSided(this, isClient, null);
    }

    public RadioListener(WorldlyPosition location) {
        this(location, UUID.randomUUID());
    }

    public RadioListener(WorldlyPosition location, UUID uuid) {
        this(uuid);
        this.location = location;
        boolean isClient = location.isClientSide();
        RadioManager.registerRouterSided(this, isClient, null);
    }

    public void setRange(float range) {
        this.range = range;
    }

    public void tryRouteHeader() {
        if (this.location == null) {
            return;
        }
        long currentTime = this.location.level.m_46467_();
        if (currentTime - this.lastHeader < (long)SimpleRadioLibrary.SERVER_CONFIG.wire.headerInterval.intValue()) {
            return;
        }
        this.lastHeader = currentTime;
    }

    public void transformer(UnaryOperator<RadioSource> transformer) {
        this.dataTransformer = transformer;
    }

    public OpusDecoder getDecoder(UUID sender) {
        return this.decoders.computeIfAbsent(sender, uuid -> CommonRadioPlugin.serverApi.createDecoder());
    }

    public void onData(byte[] data) {
    }

    public void onSource(RadioSource source) {
        if (this.dataTransformer != null) {
            source = (RadioSource)this.dataTransformer.apply(source);
        }
        this.compileActivity(source);
        source.delegate(this.reference);
        this.tryRouteHeader();
        this.route(source);
    }

    @Override
    public void tick(int tickCount) {
        super.tick(tickCount);
    }
}

