/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.items;

import com.codinglitch.simpleradio.CommonSimpleRadio;
import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.Listening;
import com.codinglitch.simpleradio.api.central.Receiving;
import com.codinglitch.simpleradio.api.central.Speaking;
import com.codinglitch.simpleradio.api.central.Transmitting;
import com.codinglitch.simpleradio.core.central.WorldTicking;
import com.codinglitch.simpleradio.core.registry.SimpleRadioFrequencing;
import com.codinglitch.simpleradio.core.registry.SimpleRadioSounds;
import com.codinglitch.simpleradio.radio.CommonRadioPlugin;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSpeaker;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TransceiverItem
extends Item
implements Listening,
Speaking,
Receiving,
Transmitting,
WorldTicking {
    public TransceiverItem(Item.Properties settings) {
        super(settings);
    }

    protected void setupRouters(RadioListener listener, RadioSpeaker speaker, RadioReceiver receiver, RadioTransmitter transmitter) {
        speaker.range = SimpleRadioLibrary.SERVER_CONFIG.transceiver.speakingRange.intValue();
        listener.range = SimpleRadioLibrary.SERVER_CONFIG.transceiver.listeningRange.intValue();
        speaker.category = CommonRadioPlugin.TRANSCEIVERS_CATEGORY;
        transmitter.frequencingType(SimpleRadioFrequencing.TRANSCEIVER);
        receiver.frequencingType(SimpleRadioFrequencing.TRANSCEIVER);
        listener.link = this.getClass();
        speaker.link = this.getClass();
        receiver.link = this.getClass();
        transmitter.link = this.getClass();
    }

    private void activate(Level level, ItemStack stack, String frequencyName, String modulation, Entity entity, UUID owner) {
        RadioListener listener = this.startListening(entity, owner);
        RadioSpeaker speaker = this.startSpeaking(entity, owner);
        RadioReceiver receiver = this.startReceiving(entity, frequencyName, Frequency.modulationOf(modulation), owner);
        RadioTransmitter transmitter = this.startTransmitting(entity, frequencyName, Frequency.modulationOf(modulation), owner);
        listener.owner = entity;
        speaker.owner = entity;
        receiver.owner = entity;
        transmitter.owner = entity;
        listener.tryAddRouter(transmitter);
        receiver.tryAddRouter(speaker);
        this.setupRouters(listener, speaker, receiver, transmitter);
        transmitter.transmitCriteria((source, router) -> {
            Frequency frequency;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack using = player.m_21211_();
                if (!(using.m_41720_() instanceof TransceiverItem)) {
                    return false;
                }
                CompoundTag usingTag = using.m_41784_();
                if (!usingTag.m_128441_("frequency") || !usingTag.m_128441_("modulation")) {
                    return false;
                }
                if (!usingTag.m_128461_("frequency").equals(frequencyName) || !usingTag.m_128461_("modulation").equals(modulation)) {
                    return false;
                }
            }
            return (frequency = this.getFrequency(stack)) != null;
        });
    }

    private void inactivate(Level level, String frequencyName, String modulation, UUID owner) {
        this.stopListening(owner, level.f_46443_);
        this.stopSpeaking(owner, level.f_46443_);
        this.stopReceiving(frequencyName, Frequency.modulationOf(modulation), owner);
        this.stopTransmitting(frequencyName, Frequency.modulationOf(modulation), owner);
    }

    public int getCooldown() {
        return 20;
    }

    public void m_142312_(CompoundTag tag) {
        super.m_142312_(tag);
        if (tag.m_128441_("activated")) {
            tag.m_128473_("activated");
        }
    }

    public void m_142023_(ItemEntity itemEntity) {
        super.m_142023_(itemEntity);
        CompoundTag tag = itemEntity.m_32055_().m_41784_();
        if (tag.m_128441_("frequency") && tag.m_128441_("modulation") && tag.m_128441_("reference")) {
            this.inactivate(itemEntity.m_9236_(), tag.m_128461_("frequency"), tag.m_128461_("modulation"), tag.m_128342_("reference"));
        }
    }

    public void entityTick(ItemStack stack, Entity entity) {
        if (entity.m_213877_()) {
            return;
        }
        Level level = entity.m_9236_();
        CompoundTag tag = stack.m_41784_();
        String frequency = tag.m_128461_("frequency");
        String modulation = tag.m_128461_("modulation");
        this.tick(stack, level);
        if (frequency.isEmpty() || modulation.isEmpty()) {
            return;
        }
        if (!Frequency.check(frequency)) {
            CommonSimpleRadio.info("Invalid frequency {}, replacing with default", frequency);
            frequency = this.getDefaultFrequency();
            tag.m_128359_("frequency", frequency);
        }
        RadioRouter activeRouter = null;
        if (tag.m_128441_("reference")) {
            activeRouter = RadioManager.getRouterSided(tag.m_128342_("reference"), level.f_46443_);
        }
        if (activeRouter != null) {
            if (activeRouter.owner == null) {
                activeRouter = null;
            } else if (!activeRouter.owner.m_20148_().equals(entity.m_20148_())) {
                activeRouter = null;
            } else if (tag.m_128441_("reference")) {
                Object items = List.of();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    items = player.m_150109_().f_35974_;
                } else if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    items = livingEntity.m_20158_();
                }
                items.forEach(slotStack -> {
                    if (slotStack.m_41619_()) {
                        return;
                    }
                    if (!slotStack.m_41782_()) {
                        return;
                    }
                    CompoundTag slotTag = slotStack.m_41783_();
                    if (!slotTag.m_128441_("reference")) {
                        return;
                    }
                    if (!slotTag.m_128342_("reference").equals(tag.m_128342_("reference"))) {
                        return;
                    }
                    if (!slotStack.equals(stack)) {
                        tag.m_128473_("reference");
                    }
                });
                if (!tag.m_128441_("reference")) {
                    activeRouter = null;
                }
            }
        }
        UUID activationUUID = null;
        if (entity.m_9236_().f_46443_) {
            if (tag.m_128441_("reference") && activeRouter == null) {
                activationUUID = tag.m_128342_("reference");
            }
        } else {
            if (activeRouter != null) {
                return;
            }
            if (!tag.m_128441_("reference")) {
                activationUUID = UUID.randomUUID();
                tag.m_128362_("reference", activationUUID);
            } else {
                activationUUID = tag.m_128342_("reference");
            }
        }
        if (activationUUID == null) {
            return;
        }
        CommonSimpleRadio.debug("Activated transceiver using UUID {}!", activationUUID);
        frequency = tag.m_128461_("frequency");
        modulation = tag.m_128461_("modulation");
        this.activate(level, stack, frequency, modulation, entity, activationUUID);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (selected) {
            return;
        }
        this.entityTick(stack, entity);
    }

    @Override
    public void worldTick(ItemEntity item, Level level) {
        this.entityTick(item.m_32055_(), (Entity)item);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltip) {
        this.appendTooltip(stack, components);
        super.m_7373_(stack, level, components, tooltip);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        level.m_5594_(player, player.m_20183_(), SimpleRadioSounds.RADIO_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            level.m_5594_(player, user.m_20183_(), SimpleRadioSounds.RADIO_CLOSE, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_36335_().m_41524_((Item)this, this.getCooldown());
        }
        super.m_5551_(stack, level, user, remainingUseTicks);
    }
}

