/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core.central;

import com.codinglitch.simpleradio.client.core.central.AnimationInstance;
import com.codinglitch.simpleradio.client.core.central.ModelAnimations;
import com.codinglitch.simpleradio.core.central.Animatable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public abstract class AnimatableModel
extends Model {
    protected final Map<Integer, AnimationDefinition> animations = new HashMap<Integer, AnimationDefinition>();
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public AnimatableModel(Function<ResourceLocation, RenderType> function) {
        super(function);
    }

    public abstract ModelPart root();

    public Optional<ModelPart> getAnyDescendantWithName(String name) {
        return name.equals("root") ? Optional.of(this.root()) : this.root().m_171331_().filter(part -> part.m_233562_(name)).findFirst().map(part -> part.m_171324_(name));
    }

    protected void animate(AnimationState animationState, AnimationDefinition animationDefinition, float age) {
        animationState.m_216974_(age, 20.0f);
        animationState.m_216979_(state -> ModelAnimations.animate(this, animationDefinition, state.m_216981_(), 1.0f, ANIMATION_VECTOR_CACHE));
    }

    public void setupAnim(Animatable animatable, float ageInTicks) {
        this.root().m_171331_().forEach(ModelPart::m_233569_);
        for (Map.Entry<Integer, AnimationDefinition> entry : this.animations.entrySet()) {
            AnimationInstance instance = animatable.getAnim(entry.getKey());
            AnimationDefinition animation = entry.getValue();
            this.animate(instance, animation, ageInTicks);
        }
    }

    public void allocate(int id, AnimationDefinition definition) {
        this.animations.put(id, definition);
    }

    public abstract void m_7695_(PoseStack var1, VertexConsumer var2, int var3, int var4, float var5, float var6, float var7, float var8);
}

