/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.client.core;

import com.codinglitch.simpleradio.SimpleRadioLibrary;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundActivityPacket;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundRegisterRouterPacket;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundSpeakSoundPacket;
import com.codinglitch.simpleradio.core.networking.packets.ClientboundWireEffectPacket;
import com.codinglitch.simpleradio.core.registry.entities.Wire;
import com.codinglitch.simpleradio.radio.RadioRouter;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import org.joml.Math;

public class SimpleRadioClientNetworking {
    public static void handleActivityPacket(ClientboundActivityPacket packet) {
        float activity = packet.activity();
        short identifier = packet.identifier();
        Minecraft.m_91087_().execute(() -> {
            RadioRouter router = ClientRadioManager.getRouter(identifier);
            if (router == null) {
                return;
            }
            router.activity = activity;
            router.activityTime = SimpleRadioLibrary.SERVER_CONFIG.router.activityTime;
        });
    }

    public static void handleRegisterRouter(ClientboundRegisterRouterPacket packet) {
        short mapping = packet.mapping();
        short identifier = packet.identifier();
        Minecraft.m_91087_().execute(() -> ClientRadioManager.finalizeRouter(mapping, identifier));
    }

    public static void handleSpeakSound(ClientboundSpeakSoundPacket packet) {
        Minecraft.m_91087_().execute(() -> ClientRadioManager.speakSound(packet));
    }

    public static void handleWireEffect(ClientboundWireEffectPacket packet) {
        int id = packet.entityId();
        boolean reversed = packet.reversed();
        Minecraft.m_91087_().execute(() -> {
            if (!SimpleRadioLibrary.CLIENT_CONFIG.wire.effect.booleanValue()) {
                return;
            }
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(id);
            if (entity instanceof Wire) {
                Wire wire = (Wire)entity;
                Wire.Effect effect = new Wire.Effect();
                if (reversed) {
                    effect.progress = Math.round((float)((float)SimpleRadioLibrary.CLIENT_CONFIG.wire.effectTime.intValue() * wire.getLength()));
                    effect.direction = -1;
                } else {
                    effect.progress = 0;
                    effect.direction = 1;
                }
                wire.effectList.add(effect);
            }
        });
    }
}

